package ru.yandex.autotests.direct.web.pages.campaigns.blocks.popups;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * Попап параметров сортировки
 *
 * @author Vitaliy_Dobriyan
 */
@Name("Попап параметров сортировки")
@FindBy(xpath = "//div[contains(@class, 'b-campaigns-settings')]")
public class SortParametersPopUpBlock extends HtmlElement {

    @Name("Радиобаттон параметра")
    @FindBy(xpath = ".//input[@class = 'radiobox__control']")
    private RadioBEM parameterRadioButton;

    @Name("Кнопка 'Показать'")
    @FindBy(xpath = ".//button[@type = 'submit']")
    private WebElement showButton;

    @Name("Кнопка 'Отменить'")
    @FindBy(xpath = ".//button[contains(@class, 'b-campaigns-settings__cancel')]")
    private WebElement cancelButton;

    public RadioBEM getParameterRadioButton() {
        return parameterRadioButton;
    }

    public WebElement getShowButton() {
        return showButton;
    }

    public WebElement getCancelButton() {
        return cancelButton;
    }
}