package ru.yandex.autotests.direct.web.pages.campaigns.timetarget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.campaigns.timetarget.elements.DaySquareBEM;
import ru.yandex.autotests.direct.web.pages.campaigns.timetarget.elements.TimeTargetTableCheckBox;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static ru.yandex.autotests.direct.web.util.converters.TimeTargetConverter.toDaySquaresMap;
import static ru.yandex.autotests.direct.web.util.converters.TimeTargetConverter.toTimeTargetCheckBoxesList;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@FindBy(xpath = ".//div[./div[contains(@class, 'b-time-targeting-scale-board_js_inited')]]")
public class TimeTargetParametersDaysTable extends HtmlElement {
    protected HashMap<ImmutablePair<Integer, Integer>, DaySquareBEM> daySquares;

    private Cash cashedWebElements = new Cash();

    private class Cash {
        public ArrayList<TimeTargetTableCheckBox> dayCheckBoxes;
        public ArrayList<TimeTargetTableCheckBox> hourCheckBoxes;
    }


    @Name("Коллекция чекбоксов для строк")
    @FindBy(xpath = ".//span[contains(@class, 'b-time-targeting-scale-board__day-checkbox')]")
    protected List<WebElement> dayCheckBoxesWebElements;

    @Name("Коллекция чекбоксов для столбцов")
    @FindBy(xpath = ".//div[contains(@class, 'b-time-targeting-scale-board__hour-checkbox')]/span")
    protected List<WebElement> hourCheckBoxesWebElements;

    @Name("Коллекция элементов таблицы временного таргетинга")
    @FindBy(xpath = ".//div[contains(@class, 'b-time-targeting-scale-board__hour-wrap')]/div")
    protected List<WebElement> daySquareWebElements;

    @Name("Всего часов в рабочие дни с заголовком")
    @FindBy(xpath = ".//div[contains(@class, 'b-time-targeting-toolbar__total')]")
    protected WebElement workingHoursCounterContainer;

    @Name("Всего часов в рабочие дни")
    @FindBy(xpath = ".//span[contains(@class, 'b-time-targeting-toolbar__total-count')]")
    protected WebElement workingHoursCounter;

    @Name("Ссылка выбора всех дней")
    @FindBy(xpath = ".//span[contains(@class, '-time-targeting-toolbar__quick-select') and contains(@data-bem, 'all')]")
    protected WebElement quickSelectAllHours;

    @Name("Ссылка выбора рабочих часов")
    @FindBy(xpath = ".//span[contains(@class, '-time-targeting-toolbar__quick-select') and contains(@data-bem, 'workdays')]")
    protected WebElement quickSelectWorkingHours;

    protected ArrayList<TimeTargetTableCheckBox> getDayCheckBoxes() {
        if (cashedWebElements.dayCheckBoxes == null)
            cashedWebElements.dayCheckBoxes = toTimeTargetCheckBoxesList(dayCheckBoxesWebElements);
        return cashedWebElements.dayCheckBoxes;
    }

    protected HashMap<ImmutablePair<Integer, Integer>, DaySquareBEM> getDaySquares() {
        if (daySquares == null)
            daySquares = toDaySquaresMap(daySquareWebElements);
        return daySquares;
    }

    protected ArrayList<TimeTargetTableCheckBox> getHourCheckBoxes() {
        if (cashedWebElements.hourCheckBoxes == null)
            cashedWebElements.hourCheckBoxes = toTimeTargetCheckBoxesList(hourCheckBoxesWebElements);
        return cashedWebElements.hourCheckBoxes;
    }

    public WebElement getQuickSelectAllHours() {
        return quickSelectAllHours;
    }

    public WebElement getQuickSelectWorkingHours() {
        return quickSelectWorkingHours;
    }

    public WebElement getWorkingHoursCounter() {
        return workingHoursCounter;
    }

    public WebElement getWorkingHoursCounterContainer() {
        return workingHoursCounterContainer;
    }

    public DaySquareBEM getTimeTargetDay(int day, int hour) {
        return getDaySquares().get(ImmutablePair.of(day, hour));
    }

    public TimeTargetTableCheckBox getDayCheckBox(int day) {
        return getDayCheckBoxes().get(day - 1);
    }

    public TimeTargetTableCheckBox getHourCheckBox(int hour) {
        return getHourCheckBoxes().get(hour);
    }
}