package ru.yandex.autotests.direct.web.pages.campaigns.timetarget;

import java.util.HashMap;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.pages.campaigns.timetarget.elements.CoefficientScaleItem;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.autotests.direct.web.webelements.bem.TumblerBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Created by shmykov on 18.06.14.
 */
@Name("Временной таргетинг")
@FindBy(xpath = ".//div[contains(@class, 'popup__content') and .//div[contains(@class,'b-time-targeting')]]")
public class TimeTargetPopupBlock extends ExtendedHtmlElement {
    @Name("Группа часовых поясов")
    @FindBy(css = ".b-time-targeting-timezone__regions select")
    protected SelectBEM timeZoneGroup;

    @Name("Часовой пояс")
    @FindBy(css = ".b-time-targeting-timezone__timezones select")
    protected SelectBEM timeZone;

    @Name("Режим управления ставками")
    @FindBy(css = ".b-time-targeting__row_type_mode-switcher")
    private WebElement bidManagement;

    @Name("Учитывать рабочие выходные")
    @FindBy(css = ".b-time-targeting-holidays__checkbox_type_intoAccountWeekend input")
    protected CheckBoxBEM considerWorkingHolidays;

    @Name("Подсказка учитывать рабочие выходные")
    @FindBy(css = ".b-time-targeting-holidays__checkbox_type_intoAccountWeekend img")
    protected HtmlElement considerWorkingHolidaysHelp;

    @Name("Учитывать праздничные дни")
    @FindBy(css = ".b-time-targeting-holidays__checkbox_type_intoAccountHolidays input")
    protected CheckBoxBEM considerHolidays;

    @Name("Подсказка для учета праздничных дней")
    @FindBy(css = ".b-time-targeting-holidays__checkbox_type_intoAccountHolidays img")
    protected HtmlElement holidaysHelp;

    @Name("Показывать в праздничные дни")
    @FindBy(css=".b-time-targeting-holidays__radiobox input")
    protected RadioBEM showOnHolidays;

    @Name("Сообщение об ошибке")
    @FindBy(css = ".b-time-targeting__errors")
    protected WebElement errorMessage;

    @Name("Показывать в праздничные дни с")
    @FindBy(css = ".b-time-targeting-holidays__select_type_from select")
    protected SelectBEM showOnHolidaysFrom;

    @Name("Показывать в праздничные дни до")
    @FindBy(css = ".b-time-targeting-holidays__select_type_to select")
    protected SelectBEM showOnHolidaysTo;

    @Name("Переключатель режима управления ставками")
    @FindBy(xpath = ".//span[contains(@class,'b-time-targeting__mode-switcher')]//input")
    protected TumblerBEM coefManagingSwitcher;

    @Name("Текстовое поле для ввода коэффициента")
    @FindBy(css = "span.b-time-targeting-scale__slider-input input")
    protected TextInput coefficientInput;

    @Name("Кнопка 'Сохранить'")
    @FindBy(css = "button.b-time-targeting-decorator__footer-button-save")
    private Button saveButton;

    @Name("Кнопка 'Отмена'")
    @FindBy(css = "button.b-time-targeting-decorator__footer-button-cancel")
    private Button cancelButton;

    @Name("Коэффициент цены клика для выходных")
    @FindBy(css = ".b-time-targeting-holidays__select_type_level select")
    protected SelectBEM holidayCoef;

    @Name("Кнопка 'Открыть в новом окне' в попапе с помощью")
    @FindBy(xpath = "//div[contains(@class,'popup_visibility_visible')]" +
            "//span[contains(@class, 'b-modal-popup-opener__target-blank')]/span")
    private Button openInNewWindowButton;

    protected HashMap<Integer, CoefficientScaleItem> coefficientScaleItems;

    public Button getCancelButton() {
        return cancelButton;
    }

    public TumblerBEM getCoefManagingSwitcher() {
        return coefManagingSwitcher;
    }

    public CheckBox getConsiderHolidays() {
        return considerHolidays;
    }

    public CheckBox getConsiderWorkingHolidays() {
        return considerWorkingHolidays;
    }

    public WebElement getConsiderWorkingHolidaysHelp() {
        return considerWorkingHolidaysHelp;
    }

    public Button getOpenInNewWindowButton() {
        return openInNewWindowButton;
    }

    public void setDontShowOnHolidays() {
         showOnHolidays.selectByValue("0");
    }

    public WebElement getErrorMessage() {
        return errorMessage;
    }

    public SelectBEM getHolidayCoef() {
        return holidayCoef;
    }

    public WebElement getHolidaysHelp() {
        return holidaysHelp;
    }

    public Button getSaveButton() {
        return saveButton;
    }

    public void setShowOnHolidays() {
        showOnHolidays.selectByValue("1");
    }

    public WebElement getShowOnHolidaysSelectedButton () {
        return showOnHolidays.getSelectedButton();
    }

    public SelectBEM getShowOnHolidaysFrom() {
        return showOnHolidaysFrom;
    }

    public SelectBEM getShowOnHolidaysTo() {
        return showOnHolidaysTo;
    }

    public SelectBEM getTimeZone() {
        return timeZone;
    }

    public SelectBEM getTimeZoneGroup() {
        return timeZoneGroup;
    }

    public WebElement getCoefficientInputWebElement(){
        return coefficientInput.getWrappedElement();
    }

    public void selectCoefficientValue(Integer value) {
        new WebElementsActions(this.config).fillTextInputWithClickAndEvents(coefficientInput, String.valueOf(value));
    }

    public Integer getSelectedCoefValue() {
        return  Integer.valueOf(coefficientInput.getText());
    }

    public void setTimeZone(String timeZoneValue) {
        getTimeZone().selectByValue(timeZoneValue);
    }

    public void setTimeZoneGroup(String group) {
        getTimeZoneGroup().selectByVisibleText(group);
    }

    private WebElement getBidManagement() {
        return bidManagement;
    }

    public void checkBidManagement(Matcher matcher) {
        assertThat("режим управления ставками не соответсвует ожиданиям", getBidManagement(), matcher);
    }
}

