package ru.yandex.autotests.direct.web.pages.campaigns.timetarget.elements;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.openqa.selenium.WebElement;

import ru.yandex.qatools.htmlelements.element.TypifiedElement;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class CoefficientScaleItem extends TypifiedElement {
    /**
     * Specifies wrapped {@link org.openqa.selenium.WebElement}.
     *
     * @param wrappedElement {@code WebElement} to wrap.
     */
    public CoefficientScaleItem(WebElement wrappedElement) {
        super(wrappedElement);
    }

    public void click() {
        getWrappedElement().click();
    }

    public int getCoefficient() {

        Pattern pattern = Pattern.compile("scale__point_level_\\d{1,3}");
        Matcher matcher = pattern.matcher(getWrappedElement().getAttribute("class"));
        if (matcher.find()) {
            return Integer.parseInt(matcher.group().replace("scale__point_level_", ""));
        } else {
            throw new RuntimeException("Percentage value is not found");
        }
    }

}
