package ru.yandex.autotests.direct.web.pages.campaigns.timetarget.elements;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.openqa.selenium.WebElement;

import ru.yandex.qatools.htmlelements.element.TypifiedElement;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class DaySquareBEM extends TypifiedElement {
    /**
     * Specifies wrapped {@link org.openqa.selenium.WebElement}.
     *
     * @param wrappedElement {@code WebElement} to wrap.
     */
    public DaySquareBEM(WebElement wrappedElement) {
        super(wrappedElement);
    }

    public void click() {
        getWrappedElement().click();
    }

    public int getCoefficient() {
        if (!isSelected())
            return 0;
        String value = getWrappedElement().getAttribute("title").replace("%", "");
        return value.equals("") ? 100 : Integer.parseInt(value);
    }

    public boolean isSelected() {
        Pattern pattern = Pattern.compile("board__hour_level_\\d{1,3}");
        Matcher matcher = pattern.matcher(getWrappedElement().getAttribute("class"));
        if (matcher.find()) {
            return ! matcher.group().contains("level_0");
        } else {
            throw new RuntimeException("board__hour_level_ parameter of 'class' attribute is not found");
        }
    }

    public int getDay() {
        Pattern pattern = Pattern.compile("scale-board__hour_day_\\d");
        Matcher matcher = pattern.matcher(getWrappedElement().getAttribute("class"));
        if (matcher.find()) {
            return Integer.parseInt(matcher.group().replace("scale-board__hour_day_", ""));
        } else {
            throw new RuntimeException("scale-board__hour_day_ parameter of 'class' attribute is not found");
        }
    }

    public int getHour() {
        Pattern pattern = Pattern.compile("scale-board__hour_code_[A-X]");
        Matcher matcher = pattern.matcher(getWrappedElement().getAttribute("class"));
        if (matcher.find()) {
            return matcher.group().replace("scale-board__hour_code_", "").codePointAt(0) - 65;
        } else {
            throw new RuntimeException("scale-board__hour_code_ parameter of 'class' attribute is not found");
        }
    }

}
