package ru.yandex.autotests.direct.web.pages.campaigns.timetarget.elements;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

import ru.yandex.qatools.htmlelements.element.CheckBox;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class TimeTargetTableCheckBox extends CheckBox {
    /**
     * Specifies wrapped {@link org.openqa.selenium.WebElement}.
     *
     * @param wrappedElement {@code WebElement} to wrap.
     */
    public TimeTargetTableCheckBox(WebElement wrappedElement) {
        super(wrappedElement);
    }

    @Override
    public boolean isSelected() {
            return getWrappedElement().getAttribute("class").contains("checkbox_checked_yes");
    }

    public void click() {
        getWrappedElement().findElement(By.xpath(".//input")).click();
    }

    @Override
    public void select() {
        if (!isSelected()) {
            click();
        }
    }

    @Override
    public void deselect() {
        if (isSelected()) {
            click();
        }
    }
}
