package ru.yandex.autotests.direct.web.pages.clients;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * Created with IntelliJ IDEA.
 * User: alex-samo
 * Date: 08.11.13
 * Time: 18:16
 * To change this template use File | Settings | File Templates.
 */

public class CreateLoginPage extends BasePageObject implements IWebFrom<AccountWeb> {


    @Name("Логин")
    @FindBy(xpath = ".//input[@name='newlogin']")
    private TextInput loginTextInput;

    @Name("Имя")
    @FindBy(xpath = ".//input[@name='name']")
    private TextInput nameTextInput;

    @Name("Фамилия")
    @FindBy(xpath = ".//input[@name='family']")
    private TextInput surnameTextInput;

    @Name("Пароль")
    @FindBy(xpath = ".//input[@name='password1']")
    private TextInput passwordTextInput;

    @Name("Подтвердите пароль")
    @FindBy(xpath = ".//input[@name='password2']")
    private TextInput confirmPasswordTextInput;

    @Name("Зарегистрировать")
    @FindBy(xpath = ".//button[@type='submit']")
    private Button registerButton;

    @Override
    public void fillParameters(AccountWeb accountWeb) {
        fillTextInput(loginTextInput, accountWeb.getLogin());
        fillTextInput(nameTextInput, accountWeb.getName());
        fillTextInput(surnameTextInput, accountWeb.getSurname());
        fillTextInput(passwordTextInput, accountWeb.getPassword());
        fillTextInput(confirmPasswordTextInput, accountWeb.getPassword());
    }

    @Override
    public void checkParameters(AccountWeb expectedBean) {
        assertThat("неверные параметры бина ", getFormFieldsAccording(expectedBean), beanEquals(expectedBean));
    }

    @Override
    public AccountWeb getFormFieldsAccording(AccountWeb expectedBean) {
        //not implement yet
        return null;
    }

    public void clickOnRegisterButton() {
        registerButton.click();
    }


}
