package ru.yandex.autotests.direct.web.pages.clients;

import java.util.List;
import java.util.NoSuchElementException;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

import ru.yandex.qatools.htmlelements.element.Select;

public class DnaPageSelect extends Select {

    private final static String POPUP_XPATH = "//div[contains(@class, 'select2__popup')]" +
            "[contains(@class, 'popup2_visible_yes')]";

    public DnaPageSelect(WebElement wrappedElement) {
        super(wrappedElement);
    }

    private WebElement getPopupList() {
        return this.getWrappedElement().findElement(By.xpath(POPUP_XPATH));
    }

    @Override
    public void selectByValue(String text) {
        getOptions()
                .stream()
                .filter(x -> x.getText().contains(text))
                .findFirst().orElseThrow(NoSuchElementException::new)
                .click();
    }

    @Override
    public void selectByVisibleText(String text) {
        getOptions()
                .stream()
                .filter(x -> x.getText().equals(text))
                .findFirst().orElseThrow(NoSuchElementException::new)
                .click();
    }

    @Override
    public List<WebElement> getOptions() {
        getWrappedElement().click();
        return getPopupList().findElements(By.xpath(".//div[@role='option']/span"));
    }
}