package ru.yandex.autotests.direct.web.pages.clients;

import java.util.LinkedList;
import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.SubClientAction;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.clients.blocks.ShowClientsTable;
import ru.yandex.autotests.direct.web.pages.priceconstructor.PriceConstructorBem;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.isDisplayed;

/**
 * User: buhter
 * Date: 26.02.13
 * Time: 16:20
 * Страница с таблицей клиентов агентства
 */

@NamedUrls({
        @NamedUrl(name = "show.clients.page", url = "/registered/main.pl?cmd=showClients"),
        @NamedUrl(name = "show.archieved.clients.page", url = "/registered/main.pl?cmd=showClients&tab=arch")
})
public class ShowClientsPage extends BasePageObject {


    @Name("Поле поиска клиентов")
    @FindBy(xpath = ".//input[@class = 'input__control']")
    private TextInput searchInput;

    @Name("главный представитель агентства")
    @FindBy(xpath = "(.//a[contains(@href,'mailto')])[2]")
    private WebElement seniorAgencyRepresentative;

    @Name("Таблица 'Мои клиенты'")
    @FindBy(xpath = ".//table[contains(@class, 'b-showclients-list__table')]")
    private ShowClientsTable clientsTable;

    @Name("Действие")
    @FindBy(xpath = ".//span[contains(@class, 'b-mass-actions__select')]//select")
    private SelectBEM actionSelect;

    @Name("Выполнить")
    @FindBy(xpath = ".//button[contains(@class,'b-mass-actions__button')]")
    private Button applyButton;

    public ShowClientsTable getClientsTable() {
        clientsTable.setConfig(config);
        return clientsTable;
    }

    private ShowClientsTable onShowClientsForm() {
        if (isDisplayed(clientsTable)) {
            return clientsTable;
        } else {
            return null;
        }
    }

    public void fillSearchInput(String query) {
        fillTextInput(searchInput, query);
    }

    public void clickOnClient(String clientName) {
        getClientsTable().clickOnClient(clientName);
    }

    public void checkAccount(AccountWeb account) {
        getClientsTable().checkAccount(account);
    }

    public void checkSeniorAgencyRepresentative(Matcher matcher) {
        assertThat(seniorAgencyRepresentative.getText(), matcher);
    }

    public List<String> getVisibleLogins() {
        ShowClientsTable showClientsTable = onShowClientsForm();
        if (showClientsTable != null) {
            return showClientsTable.getVisibleClients();
        } else {
            return new LinkedList<>();
        }
    }

    public void checkClientsListLogins(Matcher<List<String>> matcher) {
        assertThat(getVisibleLogins(), matcher);
    }

    public void checkClientAuthorizationFootnoteText(String clientLogin, Matcher matcher) {
        getClientsTable().checkClientAuthorizationFootnoteText(clientLogin, matcher);
    }

    public void openEditClientPage(String clientLogin) {
        getClientsTable().openEditClientPage(clientLogin);
    }

    public void clickOnArchiveClientLink(String clientLogin) {
        getClientsTable().clickOnArchiveClientLink(clientLogin);
    }

    public void clickOnUnArchiveClientLink(String clientLogin) {
        getClientsTable().clickOnUnArchiveClientLink(clientLogin);
    }

    public void setClientCheckBox(String clientLogin, Boolean state) {
        getClientsTable().setClientCheckBox(clientLogin, state);
    }

    public void selectAction(SubClientAction subClientAction) {
        actionSelect.selectByVisibleText(subClientAction.toString());
    }

    public void clickOnApplyButton() {
        applyButton.click();
    }

}
