package ru.yandex.autotests.direct.web.pages.clients;

import org.hamcrest.Matcher;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.clients.blocks.ShowClientsTable;
import ru.yandex.autotests.direct.web.pages.clients.blocks.ShowManagerMyClientsAgenciesTable;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * Created with IntelliJ IDEA.
 * User: alex-samo
 * Date: 08.11.13
 * Time: 16:00
 * To change this template use File | Settings | File Templates.
 */

@NamedUrls({
        @NamedUrl(name = "show.manager.my.clients.page", url = "/registered/main.pl?cmd=showManagerMyClients"),
        @NamedUrl(name = "show.manager.my.clients.page.potential.tab",
                url = "/registered/main.pl?cmd=showManagerMyClients&tab=potential")
})
public class ShowManagerMyClientsPage extends BasePageObject {


    @Name("Найти клиентов и агентства")
    @FindBy(xpath = ".//input[@class='input__control']")
    private TextInput searchInput;

    @Name("Мои клиенты")
    @FindBy(css = ".b-showclients-list_type_manager-clients")
    private ShowClientsTable showClientsTable;

    @Name("Агентства")
    @FindBy(css = ".b-showclients-list_type_manager-agents")
    private ShowManagerMyClientsAgenciesTable agenciesTable;

    public void fillSearchInput(String query) {
        fillTextInput(searchInput, query);
    }

    public void checkVisibleAgencyLoginsList(Matcher<Iterable<? super String>> matcher) {
        assertThat(agenciesTable.getVisibleClients(), matcher);
    }

    public void checkVisibleClientLoginsList(Matcher<Iterable<? super String>> matcher) {
        assertThat(showClientsTable.getVisibleClients(), matcher);
    }
}
