package ru.yandex.autotests.direct.web.pages.clients;

import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.Link;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class StepZeroPage extends BasePageObject {


    @Name("Строка ввода логина")
    @FindBy(name = "newlogin")
    private TextInput loginInput;

    @Name("Зарегистрировать логин для нового клиента")
    @FindBy(xpath = ".//div[@class='p-new-banner-step-zero__client-action']/*")
    private Link registerNewClientLoginLink;

    @Name("Далее")
    @FindBy(xpath = ".//button[@type='submit']")
    private Button nextButton;

    @Name("Ссылка 'открыть в новом окне'")
    @FindBy(xpath = ".//span[contains(@class, 'b-modal-popup-opener__target-blank popup__target-blank')]")
    private Link openPopupInNewWindowLink;

    public void inputLogin(String login) {
        fillTextInput(loginInput, login);
    }

    public void clickOnRegisterNewClientLoginLink() {
        registerNewClientLoginLink.click();
    }

    public void clickNext() {
        nextButton.click();
    }

    public void openPopupInNewWindow() {
        openPopupInNewWindowLink.click();
    }
}
