package ru.yandex.autotests.direct.web.pages.clients;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.Select;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillSelect;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class StepZeroProcessPage extends BasePageObject implements IWebFrom<AccountWeb> {


    @Name("Имя")
    @FindBy(xpath = ".//input[@name = 'name']")
    private TextInput nameInput;

    @Name("Выбор страны")
    @FindBy(css = "select.b-choose-country__select")
    private Select countrySelect;

    @Name("Телефон")
    @FindBy(xpath = ".//input[@name = 'phone']")
    private TextInput phoneInput;

    @Name("WEB")
    @FindBy(xpath = ".//input[@name = 'url']")
    private TextInput urlInput;

    @Name("email")
    @FindBy(xpath = ".//input[@name = 'email']")
    private TextInput emailInput;

    @Name("Город")
    @FindBy(xpath = ".//input[@name='city']")
    private TextInput cityInput;

    @Name("Кнопка сохранить")
    @FindBy(xpath = ".//input[@name= 'submit_create']")
    private WebElement saveButton;

    @Name("Чекбокс 'Общий счёт включен'")
    @FindBy(xpath = ".//input[@name='add_with_wallet']")
    private CheckBox checkBoxWallet;

    public void clickSave() {
        saveButton.click();
    }

    @Override
    public void fillParameters(AccountWeb account) {
        fillTextInput(nameInput, account.getName());
        fillSelect(countrySelect, account.getCountry(), SelectInputMethod.BY_TEXT);
        fillTextInput(phoneInput, account.getPhone());
        fillTextInput(urlInput, account.getUrl());
        fillTextInput(emailInput, account.getEmail());
        fillTextInput(cityInput, account.getCity());
        setCheckboxState(checkBoxWallet, account.getWalletState());
    }

    @Override
    public void checkParameters(AccountWeb expectedBean) {
        AccountWeb accountWeb = getFormFieldsAccording(expectedBean);
        assertThat("неверные параметра аккаунта " + expectedBean.getLogin(), accountWeb, beanEquals(expectedBean));
    }

    @Override
    public AccountWeb getFormFieldsAccording(AccountWeb expectedBean) {
        return null;
    }
}
