package ru.yandex.autotests.direct.web.pages.clients;

import java.util.List;

import org.hamcrest.CoreMatchers;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.CampaignTypeEnum;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static java.lang.String.format;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.collection.IsEmptyCollection.empty;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForActionResult;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.getVisibleElement;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;
import static ru.yandex.autotests.direct.web.util.matchers.IsTypifiedElementEnabledMatcher.isEnabled;

@NamedUrls({
        @NamedUrl(name = "welcome.page", url = "/dna/welcome/")
})
public class WelcomePage extends BasePageObject {

    @Name("Строка ввода email")
    @FindBy(xpath = "//input[@type='email']")
    private TextInput emailInput;

    @Name("Начать пользоваться сервисом")
    @FindBy(xpath = "//div[contains (@class, 'welcome-screen-base-settings')]/button")
    private Button startToUseServiceButton;

    @Name("Селект выбора страны")
    @FindBy(xpath = "(//button[contains(@class, 'select2__button')])[1]")
    private DnaPageSelect countrySelect;

    @Name("Селект выбора валюты")
    @FindBy(xpath = "(//button[contains(@class, 'select2__button')])[2]")
    public DnaPageSelect currencySelect;

    @Name("Чекбокс принятия соглашения")
    @FindBy(xpath = "//input[@type = 'checkbox']")
    public CheckBoxBEM acceptAgreement;

    public void fillEmail(String email) {
        fillTextInput(emailInput, email);
    }

    public void selectCountry(String country) {
        if (country == null) {
            return;
        }
        countrySelect.selectByValue(country);
    }

    public void setAcceptAgreementCheckboxState(Boolean state) {
        setCheckboxState(acceptAgreement, state);
    }

    public void selectCurrency(String currency) {
        if (currency == null) {
            return;
        }
        currencySelect.selectByValue(currency);
    }

    public List<WebElement> getCurrencyList() {
        return currencySelect.getOptions();
    }

    public Button getStartToUseServiceButton() {
        return startToUseServiceButton;
    }

    @Step("Выбираем тип создаваемой кампании {0}")
    public void clickAddCampaign(CampaignTypeEnum campaignTypeEnum) {
        clickOnAddCampaignButton(campaignTypeEnum);
    }

    public void clickOnAddCampaignButton(CampaignTypeEnum typeSelector) {
        waitForActionResult(() -> getCreateCampaignButtons(typeSelector), 10, CoreMatchers.not(empty()));
        // Hack: Кнопка состоит из двух ссылок, пока мы не навели указатель мыши на ссылку, то показывается первая
        // после наведения показывается другая. При щелчке на кнопку через Selenium API возникает проблема
        // браузер наводит курсор на кнопку и после чего щелкаемый элемент становится неведимым, но мы пытаемся на него нажать
        // поэтому жмем через js
        ((JavascriptExecutor) config.getDriver()).executeScript("arguments[0].click();",
                getVisibleElement(getCreateCampaignButtons(typeSelector)));
    }

    public List<WebElement> getCreateCampaignButtons(CampaignTypeEnum typeSelector) {
        return config.getDriver()
                .findElements(By.xpath(format("//a[contains(@href,'mediaType=%s')]", typeSelector.getValue())));
    }

    public void startToUseServiceButtonShouldBeEnabled() {
        waitForElement(startToUseServiceButton, 5, not(isEnabled()));
    }
}
