package ru.yandex.autotests.direct.web.pages.clients.blocks;

import java.util.List;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static java.util.stream.Collectors.toList;

public class ShowClientsTable extends ExtendedHtmlElement {

    private List<ShowClientsTableRow> rows;

    private List<ShowClientsTableRow> getRows() {
        return rows;
    }

    private ShowClientsTableRow getShowClientsTableRow(String clientName) {
        return getVisibleRows().stream()
                .filter(t -> t.getShowClientsCampaignsLinkText().equals(clientName))
                .findFirst().get();
    }

    private List<ShowClientsTableRow> getVisibleRows() {
        return getRows().stream()
                .filter(ShowClientsTableRow::isDisplayed)
                .collect(toList());
    }

    public void clickOnClient(String clientName) {
        ShowClientsTableRow clientRow = getShowClientsTableRow(clientName);
        if (clientRow == null) {
            throw new DirectWebError("Не найдена строка для аккаунта " + clientName);
        }
        new JavaScriptActions(config).scrollToElement(clientRow);
        clientRow.clickOnShowClientsCampaignsLink();
    }

    public void checkAccount(AccountWeb account) {
        ShowClientsTableRow clientRow = getShowClientsTableRow(account.getLogin());
        if (clientRow == null) {
            throw new DirectWebError("Не найдена строка для аккаунта " + account.getLogin());
        }
        new JavaScriptActions(config).scrollToElement(clientRow);
        clientRow.checkParameters(account);
    }

    public List<String> getVisibleClients() {
        return getVisibleRows().stream()
                .map(ShowClientsTableRow::getShowClientsCampaignsLinkText)
                .collect(toList());
    }

    public void openEditClientPage(String clientLogin) {
        ShowClientsTableRow clientRow = getShowClientsTableRow(clientLogin);
        if (clientRow == null) {
            throw new DirectWebError("Не найден клиент " + clientLogin);
        } else {
            new JavaScriptActions(config).scrollToElement(clientRow);
            clientRow.clickOnEditLink();
        }
    }

    public void checkClientAuthorizationFootnoteText(String clientLogin, Matcher matcher) {
        ShowClientsTableRow clientRow = getShowClientsTableRow(clientLogin);
        if (clientRow == null) {
            throw new DirectWebError("Не найден клиент " + clientLogin);
        } else {
            new JavaScriptActions(config).scrollToElement(clientRow);
            clientRow.checkClientAuthorizationFootnoteText(matcher);
        }
    }


    public void setClientCheckBox(String clientLogin, Boolean state) {
        ShowClientsTableRow clientRow = getShowClientsTableRow(clientLogin);
        if (clientRow == null) {
            throw new DirectWebError("Не найден клиент " + clientLogin);
        } else {
            new JavaScriptActions(config).scrollToElement(clientRow);
            clientRow.setClientCheckBox(state);
        }
    }

    public void clickOnArchiveClientLink(String clientLogin) {
        ShowClientsTableRow clientRow = getShowClientsTableRow(clientLogin);
        if (clientRow == null) {
            throw new DirectWebError("Не найден клиент " + clientLogin);
        } else {
            new JavaScriptActions(config).scrollToElement(clientRow);
            clientRow.clickOnArchiveLink();
        }
    }

    public void clickOnUnArchiveClientLink(String clientLogin) {
        ShowClientsTableRow clientRow = getShowClientsTableRow(clientLogin);
        if (clientRow == null) {
            throw new DirectWebError("Не найден клиент " + clientLogin);
        } else {
            new JavaScriptActions(config).scrollToElement(clientRow);
            clientRow.clickOnUnArchiveLink();
        }
    }
}
