package ru.yandex.autotests.direct.web.pages.clients.blocks;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

@Name("Строка в таблице клиентов")
@FindBy(xpath = ".//tr[contains(@class, 'b-showclients-list__row ')]")
public class ShowClientsTableRow extends ExtendedHtmlElement implements IWebFrom<AccountWeb> {

    //region Fields

    @Name("Чекбокс выбора клиента")
    @FindBy(xpath = ".//input[@class='checkbox__control']")
    private CheckBox clientCheckBox;

    @Name("Ссылка на страницу кампаний клиента")
    @FindBy(xpath = ".//a[contains(@href,'cmd=showCamps')]")
    protected Link showClientsCampaignsLink;

    @Name("Сноска 'клиент с правами управления' или 'клиент с правами управления, импорта из xls-файла'")
    @FindBy(xpath = ".//sup")
    private WebElement clientAuthorizationFootnote;

    @Name("Имя клиента для идентификации ряда")
    @FindBy(xpath = ".//a[contains(@href,'cmd=showCamps')]/span")
    private WebElement clientName;

    @Name("ФИО")
    @FindBy(xpath = ".//td[4]/span")
    private WebElement fio;

    @Name("Телефон")
    @FindBy(xpath = ".//td[6]/span")
    private WebElement phone;

    @Name("Email")
    @FindBy(xpath = ".//td[7]/a/span")
    private WebElement email;

    @Name("Редактировать")
    @FindBy(xpath = ".//a[contains(@href,'cmd=modifyUser')]")
    private Link editLink;

    @Name("Архивировать")
    @FindBy(xpath = ".//a[contains(@href,'cmd=archiveUser')]")
    private Link archiveLink;

    @Name("Разархивировать")
    @FindBy(xpath = ".//a[contains(@href,'cmd=unArchiveUser')]")
    private Link unArchiveLink;
    //endregion

    //region IWebForm
    @Override
    public void fillParameters(AccountWeb bean) {
        //not implemented yet
    }

    @Override
    public void checkParameters(AccountWeb expectedBean) {
        AccountWeb actualBean = getFormFieldsAccording(expectedBean);
        actualBean.setLogin(expectedBean.getLogin());
        assertThat("неверные параметра аккаунта", actualBean, beanEquals(expectedBean));
    }

    @Override
    public AccountWeb getFormFieldsAccording(AccountWeb expectedBean) {
        return inAccordanceWith(expectedBean).forNew(AccountWeb.class)
                .set("name", fio, on(WebElement.class).getText())
                .set("phone", phone, on(WebElement.class).getText())
                .set("email", email, on(WebElement.class).getText())
                .getActualBean();
    }
    //endregion

    public void setClientCheckBox(Boolean state) {
        setCheckboxState(clientCheckBox, state);
    }

    public WebElement getClientName() {
        return clientName;
    }

    public void clickOnEditLink() {
        editLink.click();
    }

    public void clickOnShowClientsCampaignsLink() {
        showClientsCampaignsLink.click();
    }

    public void checkClientAuthorizationFootnoteText(Matcher matcher) {
        assertThat(clientAuthorizationFootnote.getText(), matcher);
    }

    public String getShowClientsCampaignsLinkText() {
        return showClientsCampaignsLink.getText();
    }

    public void clickOnArchiveLink() {
        archiveLink.click();
    }

    public void clickOnUnArchiveLink() {
        unArchiveLink.click();
    }
}
