package ru.yandex.autotests.direct.web.pages.clients.blocks;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static java.util.stream.Collectors.toList;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 22.04.14
 */
public class ShowManagerMyClientsAgenciesTable extends HtmlElement {

    private List<ShowManagerMyClientsAgenciesTableRow> rows;

    private List<ShowManagerMyClientsAgenciesTableRow> getRows() {
        return rows;
    }

    private List<ShowManagerMyClientsAgenciesTableRow> getVisibleRows() {
        return getRows().stream()
                .filter(ShowManagerMyClientsAgenciesTableRow::isDisplayed)
                .collect(Collectors.toList());
    }

    public List<String> getVisibleClients() {
        return getVisibleRows().stream()
                .map(ShowManagerMyClientsAgenciesTableRow::getShowAgencyClientsLinkText)
                .collect(toList());
    }


}
