package ru.yandex.autotests.direct.web.pages.clients.blocks;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 22.04.14
 */
@Name("Строка в таблице клиентов")
@FindBy(xpath = ".//tr[contains(@class, 'b-showclients-list__row ')]")
public class ShowManagerMyClientsAgenciesTableRow extends HtmlElement implements IWebFrom<AccountWeb> {

    //region Fields

    @Name("Ссылка на страницу клиентов агентства")
    @FindBy(xpath = ".//a[contains(@href,'cmd=showClients')]")
    protected Link showAgencyClientsLink;

    //endregion

    //region IWebForm
    @Override
    public void fillParameters(AccountWeb bean) {
        //not implemented yet
    }

    @Override
    public void checkParameters(AccountWeb expectedBean) {

    }

    @Override
    public AccountWeb getFormFieldsAccording(AccountWeb expectedBean) {
        return null;
    }
    //endregion

    public String getShowAgencyClientsLinkText() {
        return showAgencyClientsLink.getText();
    }

}
