package ru.yandex.autotests.direct.web.pages.dna.filters;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

import ru.yandex.autotests.direct.web.util.DirectWebError;

public enum DnaFilterAssumption {
    EQUALS("="),
    MORE_OR_EQUALS(">="),
    LESS_OR_EQUALS("<=");

    private String text;
    private String urlCode;

    DnaFilterAssumption(String text) {
        this.text = text;
        try {
            this.urlCode = java.net.URLEncoder.encode(text, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new DirectWebError("Неподдерживаемая ошибка при кодировке");
        }
    }

    public String getValue() {
        return text;
    }

    public String getUrlCode() {
        return urlCode;
    }
}
