package ru.yandex.autotests.direct.web.pages.dna.filters.logger;

import java.util.List;

import ru.yandex.autotests.httpclientlite.core.request.utils.keyvalue.annotations.SerializeKey;

public class DnaLoggerFilter {
    @SerializeKey("№ кампании")
    private String campaignId;

    @SerializeKey("№ группы")
    private String groupId;

    @SerializeKey("№ объявления")
    private String bannerId;

    @SerializeKey("Кто изменил")
    private String whoChange;

    @SerializeKey("Статусы")
    private List<String> statuses;

    @SerializeKey("Настройки")
    private List<String> settings;

    public String getCampaignId() {
        return campaignId;
    }

    public String getGroupId() {
        return groupId;
    }

    public String getBannerId() {
        return bannerId;
    }

    public String getWhoChange() {
        return whoChange;
    }

    public List<String> getStatuses() {
        return statuses;
    }

    public List<String> getSettings() {
        return settings;
    }

    public DnaLoggerFilter withCampaignId(String campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public DnaLoggerFilter withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public DnaLoggerFilter withBannerId(String bannerId) {
        this.bannerId = bannerId;
        return this;
    }

    public DnaLoggerFilter withGroupId(Long groupId) {
        this.groupId = groupId.toString();
        return this;
    }

    public DnaLoggerFilter withBannerId(Long bannerId) {
        this.bannerId = bannerId.toString();
        return this;
    }

    public DnaLoggerFilter withWhoChange(String whoChange) {
        this.whoChange = whoChange;
        return this;
    }

    public DnaLoggerFilter withStatuses(List<String> statuses) {
        this.statuses = statuses;
        return this;
    }

    public DnaLoggerFilter withSettings(List<String> settings) {
        this.settings = settings;
        return this;
    }
}
