package ru.yandex.autotests.direct.web.pages.dna.pages.showcamps;

import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;

@NamedUrls({
        @NamedUrl(name = "dna.show.camps.page.with.filter",
                url = "/registered/main.pl?cmd=showCamps&grid=1&ulogin={1}&filter={2}")
})

public class DnaShowCampsPage extends BasePageObject {

    @Name("Фильтры")
    @FindBy(xpath = ".//div[@class='filter-control']")
    private WebElement filters;

    @Name("Шапка грида кампании")
    @FindBy(xpath = ".//div[contains(@class,'grid-screen__title')]")
    private WebElement campaignHeader;

    @Name("Список строк кампаний")
    @FindBy(xpath = ".//div[contains(@class,'public_fixedDataTableRow_main')]")
    private List<WebElement> campaignRows;

    @Name("Таблица со списком кампаний")
    @FindBy(css = ".fixedDataTableLayout_rowsContainer")
    private WebElement campaignsTable;

    public WebElement getFilters() {
        return filters;
    }

    public WebElement getCampaignHeader() {
        return campaignHeader;
    }

    public WebElement getCampaignsTable() {
        return campaignsTable;
    }
}