package ru.yandex.autotests.direct.web.pages.excel;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

public class ImportCampXlsPage extends BasePageObject {

    @Name("Согласен/не согласен")
    @FindBy(xpath = ".//input[@name='oferta']")
    private RadioBEM acceptOfertaRadio;

    @Name("Применить")
    @FindBy(xpath = ".//button[@type='submit']")
    private Button acceptButton;

    @Name("Выбрать файл")
    @FindBy(xpath = ".//span[contains(@class, 'attach__button')]//input")
    private Button chooseFile;

    public void acceptOferta() {
        acceptOfertaRadio.selectByValue("accept");
        acceptButton.click();
    }

    public void clickOnAcceptButton() {
        acceptButton.click();
    }

    public void clickOnChooseFileButton() {
        chooseFile.click();
    }
}
