package ru.yandex.autotests.direct.web.pages.excel;

import org.hamcrest.Matcher;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.excel.blocks.UploadFileBlock;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 28.07.14
 */
@NamedUrls({
        @NamedUrl(name = "manage.in.excel.page.download.tab",
                url = "/registered/main.pl?cmd=showExportedXlsList&cid={1}"),
        @NamedUrl(name = "manage.in.excel.page.upload.tab",
                url = "/registered/main.pl?cmd=showExportedXlsList&tab=import&ulogin={1}"),
        @NamedUrl(name = "manage.in.excel.page.tab",
                url = "/registered/main.pl?cmd=showExportedXlsList&tab={1}&ulogin={2}")
})
public class ShowExportedXlsListPage extends BasePageObject {

    @FindBy(css = ".p-xls-management__import-xls")
    private UploadFileBlock uploadFileBlock;

    @FindBy(css = ".p-xls-management__import-csv")
    private UploadFileBlock uploadCsvFileBlock;

    public void uploadFile(String fileName) {
        uploadFileBlock.uploadFile(fileName);
    }

    public void uploadCSVFile(String fileName) {
        uploadCsvFileBlock.uploadFile(fileName);
    }

    public void checkUploadErrors(Matcher matcher) {
        uploadFileBlock.checkUploadErrors(matcher);
    }
}
