package ru.yandex.autotests.direct.web.pages.excel;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 02.08.14
 */
public class importCampSuccessPage extends BasePageObject {

    @Name("Статус загрузки кампании")
    @FindBy(xpath = ".//div[contains(@class, 'p-xls-import-success__description-title')]")
    private WebElement campaignImportStatus;

    public void checkCampaignImportStatus(Matcher matcher) {
        assertThat("статус загрузки кампании не соответсвет ожиданиям", campaignImportStatus.getText(), matcher);
    }
}
