package ru.yandex.autotests.direct.web.pages.feeds;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.web.objects.feeds.FeedWeb;
import ru.yandex.autotests.direct.web.pages.feeds.blocks.FeedRow;
import ru.yandex.autotests.direct.web.pages.feeds.popup.EditFeedPopupBlock;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import java.util.List;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;

/**
 * Created by aleran on 08.09.2015.
 */
@NamedUrls({
        @NamedUrl(name = "show.feeds", url = "/registered/main.pl?cmd=showFeeds&ulogin={1}")
})
public class ShowFeedsPage extends BasePageObject {

    @Name("Список фидов")
    @FindBy(css = ".b-feeds-list__row")
    List<FeedRow> feedRows;


    @Name("Кнопка для удаления фидов")
    @FindBy(css = ".b-feeds-list__remove-feeds")
    private Button deleteFeedsButton;

    @Name("Кнопка для создания фида")
    @FindBy(css = ".p-manage-feeds__create-feed")
    private Button addFeedButton;

    private EditFeedPopupBlock editFeedPopupBlock;

    @Name("Лоадер списка фидов")
    @FindBy(css = ".b-feeds-list__paranja")
    private WebElement getFeedsSpinLoader;

    public void selectDeleteCheckBoxById(Long feedId) {
        getFeedRowById(String.valueOf(feedId)).selectDeleteCheckBox();
    }

    public void deleteFeeds(List<Long> feedIds) {
        feedIds.forEach(this::selectDeleteCheckBoxById);
        deleteFeedsButton.click();
        waitForGetFeedsSpinLoader();
    }

    public void deleteFeed(Long feedId) {
        selectDeleteCheckBoxById(feedId);
        deleteFeedsButton.click();
        waitForGetFeedsSpinLoader();
    }

    private void waitForGetFeedsSpinLoader(){
        waitForElement(getFeedsSpinLoader,
                (int) DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec(),
                not(WebElementMatchers.isDisplayed()));
    }

    public void clickEditFeedButton(String feedId) {
        getFeedRowById(feedId).clickEditButton();
    }

    public String getNewFeedRowId(){
        return getNewFeedRow().getFeedId();
    }

    public void clickSaveFeedButton(){
        if (!editFeedPopupBlock.isSaveButtonEnabled()){
            throw new DirectWebError("Не удалось сохранить фид");
        }
        editFeedPopupBlock.clickSaveFeedButton();
        waitForGetFeedsSpinLoader();
    }

    public void clickAddFeedButton() {
        waitForGetFeedsSpinLoader();
        addFeedButton.click();
    }

    public void fillFeedParameters(FeedWeb feed) {
        editFeedPopupBlock.fillParameters(feed);
    }

    public void checkFeedParameters(FeedWeb feedWeb) {
        editFeedPopupBlock.checkParameters(feedWeb);
    }

    public void checkDeletedFeedsNotExist(List<String> feedIds) {
        feedIds.forEach(this::checkDeletedFeedNotExist);
    }

    public void checkDeletedFeedNotExist(String feedId){
        assertThat("фид не удалился", getFeedRowById(feedId), not(WebElementMatchers.exists()));
    }

    private FeedRow getFeedRowById(String feedId) {
        FeedRow feedRow = feedRows.stream().filter(t -> t.getFeedId().equals(feedId)).findFirst().orElse(null);
        return feedRow;
    }

    private FeedRow getNewFeedRow() {
        return feedRows.stream()
                .filter(t -> t.getStatusClasses().contains("b-feeds-list__status_status_new")).findFirst().get();
    }

    public void shouldSeeCampaignIds(String feedId, List<Long> campaignIds) {
        FeedRow feedRow = getFeedRowById(feedId);
        feedRow.shouldSeeCampaignIds(campaignIds);
    }

    public void shouldSeeCampaignId(String feedId, Long campaignId) {
        FeedRow feedRow = getFeedRowById(feedId);
        feedRow.shouldSeeCampaignId(campaignId);
    }
}
