package ru.yandex.autotests.direct.web.pages.feeds.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import java.util.List;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;


/**
 * Created by aleran on 09.09.2015.
 */
public class FeedRow extends HtmlElement {

    @Name("Чекбокс для удаления фидов")
    @FindBy(css = ".checkbox input")
    private CheckBoxBEM deleteCheckBox;

    @Name("Кнопка для редактирования фида")
    @FindBy(css = "button.b-feeds-list__edit-feed")
    private Button editFeedButton;

    @Name("Идентификатор фида")
    @FindBy(css = "div.b-feeds-list__feed-id")
    private WebElement feedId;

    @Name("Статус фида")
    @FindBy(css = ".b-feeds-list__status")
    private WebElement feedStatus;

    @Name("Показать список кампаний")
    @FindBy(css = ".b-feeds-list__campaigns-popup-button")
    private Button showCampaignsButton;

    @Name("Название кампании")
    @FindBy(css = ".b-feeds-list__campaign-cid")
    private WebElement campaignIdElement;

    @Name("Список кампаний")
    @FindBy(xpath = "//div[@class = 'b-feeds-list__campaign-popup-item']")
    private List<WebElement> campaignNameList;

    public CheckBoxBEM getDeleteCheckBox() {
        return deleteCheckBox;
    }

    public void selectDeleteCheckBox() {
        deleteCheckBox.select();
    }

    public void clickEditButton() {
        editFeedButton.click();
    }

    public String getFeedId() {
        return feedId.getText().replaceFirst(".* (\\d+)\\)", "$1");
    }

    public String getStatusClasses() {
        return feedStatus.getAttribute("class");
    }

    private WebElement getCampaignId(Long campaignId) {
        return campaignNameList.stream().filter(t -> t.getText().replaceFirst(".*№ (\\d+)\\)", "$1")
                .equals(campaignId.toString())).findFirst().orElse(null);
    }

    private void checkCampaign(Long campaignId) {
        assertThat("не удалось найти кампанию с таким id", getCampaignId(campaignId), notNullValue());
    }

    public void shouldSeeCampaignIds(List<Long> campaignIds) {
        showCampaignsButton.click();
        campaignIds.stream().forEach(this::checkCampaign);
    }

    public void shouldSeeCampaignId(Long expectedCampaignId) {
        assertThat("кампания не показывается", campaignIdElement.getText().replaceAll("[^0-9]", ""), equalTo(expectedCampaignId.toString()));
    }
}
