package ru.yandex.autotests.direct.web.pages.firsthelp;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;

/**
 * @author: Alex Samokhin (alex-samo@yandex-team.ru)
 * Date: 05.12.13
 * <p>
 * Страница запросов на оптимизацию кампаний
 */


public class ViewOptimizingCommentPage extends BasePageObject {


    @Name("Комментарий к оптимизации")
    @FindBy(xpath = ".//div[contains(@class, 'content')]/p")
    public WebElement optimizingComment;

    public String getOptimizingCommentText() {
        return optimizingComment.getText();
    }

}
