package ru.yandex.autotests.direct.web.pages.firsthelp.recommendations.blocks.popups;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.firsthelp.recommendations.AcceptRecommendedBannerParameters;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.allure.webdriver.rules.WebDriverConfiguration;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.Radio;

/**
 * @author: Alex Samokhin (alex-samo@yandex-team.ru)
 * Date: 29.11.13
 */

@FindBy(xpath = ".//div[@id='accept_optimize_menu']")
public class AcceptRecommendedBannersPopupBlock extends ExtendedHtmlElement {

    @Name("Принять все/ Принять только выбранные")
    @FindBy(xpath = ".//input[@name='acceptType']")
    private Radio acceptTypeRadio;

    @Name("Принять")
    @FindBy(xpath = ".//input[contains(@class, '_submit')]")
    private Button acceptButton;

    public void fillParametersAndClickAccept(AcceptRecommendedBannerParameters parameters) {
        acceptTypeRadio.selectByValue(parameters.getAcceptRecommendedBannersType().getName());
        takeScreenshot();
        acceptButton.click();
    }

    public void setConfig(WebDriverConfiguration config) {
        this.config = config;
    }
}
