package ru.yandex.autotests.direct.web.pages.firsthelp.recommendations.blocks.popups;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * @author: Alex Samokhin (alex-samo@yandex-team.ru)
 * Date: 04.12.13
 * <p/>
 * Попап отказа от оптимизации
 */

@FindBy(xpath = ".//div[@id='declinePopup']")
public class DeclineOptimizationPopupBlock extends HtmlElement {

    @Name("Закончить оптизмизацию")
    @FindBy(xpath = ".//input[contains(@class, 'b-window__submit')]")
    private Button completeOptimizationButton;

    @Name("Комментарий")
    @FindBy(xpath = ".//textarea[@id='declineComment']")
    private WebElement commentTextArea;

    public void fillCommentAndAccept(String comment) {
        if (comment == null)
            return;
        commentTextArea.click();
        commentTextArea.clear();
        commentTextArea.sendKeys(comment);
        completeOptimizationButton.click();
    }

}
