package ru.yandex.autotests.direct.web.pages.firsthelp.recommendations.blocks.popups;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * @author: Alex Samokhin (alex-samo@yandex-team.ru)
 * Date: 05.12.13
 */

@FindBy(xpath = ".//div[@id='reject_optimize_menu']")
public class RemoveRecommendationsPopupBlock extends HtmlElement {

    @Name("Удалить")
    @FindBy(xpath = ".//input[contains(@class, 'b-window__submit')]")
    private Button removeButton;

    @Name("Комментарий")
    @FindBy(xpath = ".//textarea[contains(@class, 'b-campaigninfo-show__optimize__reject-popup__comment')]")
    private WebElement commentTextArea;

    public void fillCommentAndAccept(String comment) {
        if (comment == null)
            return;
        commentTextArea.click();
        commentTextArea.clear();
        commentTextArea.sendKeys(comment);
        removeButton.click();
    }
}
