package ru.yandex.autotests.direct.web.pages.group;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

@FindBy(xpath = ".//li[contains(@class,'b-feed-filters__item')]")
public class GroupFilterBlockBEM extends ExtendedHtmlElement {

    @Name("Название фильтра")
    @FindBy(xpath = ".//div[contains(@class,'b-feed-filter__name b-feed-filter__field')]")
    private WebElement filtersName;

    @Name("Кнопка 'Изменить'")
    @FindBy(xpath = ".//div[contains(@class,'b-control-edit-button')]//button")
    private Button editFilterButton;

    @Name("Кнопка 'Удалить' фильтр")
    @FindBy(xpath = ".//div[contains(@class,'b-control-remove-button')]//button")
    private Button deleteFilterButton;

    public void clickEditFilterButton() {
        editFilterButton.click();
    }

    public void clickDeleteFilterButton() {
        deleteFilterButton.click();
    }

    public String getFiltersName() {
        return filtersName.getText();
    }

}
