package ru.yandex.autotests.direct.web.pages.group;

import java.util.List;
import java.util.stream.Collectors;

import com.google.gson.JsonParser;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

/**
 * Created by ssdmitriev on 25.11.15.
 */
@Name("Попап меток")
public class TagsPopup extends ExtendedHtmlElement {

    @Name("Новые метки через запятую")
    @FindBy(xpath = ".//input[contains(@class, 'input__control')]")
    private WebElement tags;

    @Name("Кнопка сохранить")
    @FindBy(xpath = ".//button[contains(@class, 'save')]")
    private Button saveButton;

    @Name("Кнопка отменить")
    @FindBy(xpath = ".//button[contains(@class, 'cancel')]")
    private Button cancelButton;

    @Name("Список тэгов")
    @FindBy(xpath = ".//div[contains(@class, 'b-group-tags2-edit__checkbox-container')]//input")
    private List<CheckBoxBEM> checkBoxBEMList;

    public void fillTags(String ... tags) {
        this.tags.click();
        this.tags.clear();
        this.tags.sendKeys(StringUtils.join(tags, " "));
        //takeScreenshot();
    }

    public String getTags() {
        return checkBoxBEMList.stream().filter(x -> x.isSelected())
                .map(x -> new JsonParser().parse(x.getWrappedElement()
                        .findElement(By.xpath("../..")).getAttribute("data-bem")).getAsJsonObject()
                        .get("b-selectable-control").getAsJsonObject().get("key").getAsString())
                .collect(Collectors.joining(", "));
    }

    public void clickOnSaveButton() {
        saveButton.click();
    }

    public void clickOnCancelButton() {
        cancelButton.click();
    }
}
