package ru.yandex.autotests.direct.web.pages.group.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.RadioInputMethod;
import ru.yandex.autotests.direct.web.data.groupenums.SettingsModelEnum;
import ru.yandex.autotests.direct.web.objects.groups.feedfilter.FeedFilterBase;
import ru.yandex.autotests.direct.web.objects.groups.feedfilter.FeedFilterCondition;
import ru.yandex.autotests.direct.web.objects.groups.feedfilter.FeedFilterTree;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillRadio;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@FindBy(xpath = "//div[contains(@class, 'b-feed-filter-edit ')]")
public abstract class EditFilterBlockBase extends ExtendedHtmlElement {
    @Name("Название фильтра")
    @FindBy(xpath = ".//span[contains(@data-bem,'filter_name')]//input")
    protected TextInput filterNameTextInput;

    @Name("Дерево фидов/Условия")
    @FindBy(xpath = ".//div[contains(@data-bem,'settings-target')]//input")
    protected RadioBEM settingsTargetRadio;

    @Name("Добавить условие")
    @FindBy(xpath = ".//div[contains(@class,'b-control-add-button') and contains(@class,'condition-control')]//button")
    protected Button addConditionButton;

    @Name("Только в наличии")
    @FindBy(xpath = ".//span[contains(@class, 'filter-edit__available-checkbox')]//input")
    protected CheckBoxBEM availableCheckbox;

    @Name("Сохранить фильтр")
    @FindBy(xpath = ".//button[contains(@class, 'filter-edit__save')]")
    protected Button saveButton;

    @Name("Закрыть попап фильтра")
    @FindBy(xpath = ".//button[contains(@class, 'filter-edit__cancel')]")
    protected Button cancelButton;

    @Name("Паранжа загрузки условий")
    @FindBy(css = ".b-dynamic-media-filter-edit__spin")
    protected WebElement filterConditionSpinner;

    private List<FilterConditionBlock> performanceFilterConditionBlocks;

    private FilterTreeBlock filterTree;

    public void clickSaveButton() {
        saveButton.click();
    }

    public void clickCancelButton() {
        cancelButton.click();
    }

    public void clickAddConditionButton() {
        addConditionButton.click();
    }

    public String getFilterName() {
        return filterNameTextInput.getText();
    }

    public SettingsModelEnum getSettingsTarget() {
        return SettingsModelEnum.getEnumByValue(settingsTargetRadio.getSelectedButton().getAttribute("value"));
    }

    public Boolean getAvailable() {
        return availableCheckbox.isSelected();
    }

    protected List<FilterConditionBlock> getPerformanceFilterConditionBlocks() {
        return performanceFilterConditionBlocks;
    }

    public FeedFilterTree getFeedFilterTree(FeedFilterTree expectedBean) {
        if (expectedBean == null) {
            return null;
        }
        return filterTree.getFormFieldsAccording(expectedBean);
    }

    protected void fillFilterTree(FeedFilterTree feedFilterTree) {
        if (feedFilterTree == null) {
            return;
        }
        filterTree.fillTree(feedFilterTree);
    }

    public List<FeedFilterCondition> getFeedFilterConditions(List<FeedFilterCondition> expectedBean) {
        if (expectedBean == null) {
            return null;
        }
        List<FeedFilterCondition> feedFilterConditions = new ArrayList<>();
        for (FilterConditionBlock filterConditionBlock : getPerformanceFilterConditionBlocks()) {
            FeedFilterCondition expectedCondition = expectedBean.stream()
                    .filter(t -> t.getFeedsFilterConditionsField()
                            .equals(filterConditionBlock.getFeedsFilterConditionsField())).findFirst().orElse(null);
            assumeThat("условие найдено", expectedCondition, notNullValue());
            feedFilterConditions.add(filterConditionBlock.getFormFieldsAccording(expectedCondition));
        }
        return feedFilterConditions;
    }

    protected void fillFilterConditions(List<FeedFilterCondition> feedFilterConditions) {
        if (feedFilterConditions == null) {
            return;
        }
        getPerformanceFilterConditionBlocks().stream().forEach(FilterConditionBlock::clickRemoveConditionButton);
        for (FeedFilterCondition condition : feedFilterConditions) {
            clickAddConditionButton();
            fillFilterCondition(condition);
        }
    }

    protected void fillFilterCondition(FeedFilterCondition condition) {
        getPerformanceFilterConditionBlocks().get(getPerformanceFilterConditionBlocks().size() - 1)
                .fillFieldSelect(condition);
        getPerformanceFilterConditionBlocks().get(getPerformanceFilterConditionBlocks().size() - 1)
                .fillRelationSelect(condition);
        getPerformanceFilterConditionBlocks().get(getPerformanceFilterConditionBlocks().size() - 1)
                .fillValues(condition);
    }

    public String getFilterId() {
        Pattern pattern = Pattern.compile("\"filter_id\":[-0-9a-zA-Z\"]*");
        java.util.regex.Matcher matcher = pattern.matcher(this.getAttribute("data-bem"));
        String result = null;
        if (matcher.find()) {
            result = matcher.group().replaceAll("[\":]", "").replace("filter_id", "");
        }
        return result;
    }

    protected FeedFilterBase getFormFieldsAccording(FeedFilterBase expectedBean, FeedFilterBase resultBean) {
        inAccordanceWith(expectedBean).forExisting(resultBean)
                .set("filterId", this, on(EditFilterBlockBase.class).getFilterId())
                .set("name", this, on(EditFilterBlockBase.class).getFilterName())
                .set("settingsModelEnum", this, on(EditFilterBlockBase.class).getSettingsTarget())
                .set("available", this, on(EditFilterBlockBase.class).getAvailable())
                .getActualBean();
        resultBean.setFeedFilterTree(getFeedFilterTree(expectedBean.getFeedFilterTree()));
        resultBean.setFeedFilterConditions(getFeedFilterConditions(expectedBean.getFeedFilterConditions()));
        return resultBean;
    }

    public void fillParameters(FeedFilterBase bean) {
        waitForElement(filterConditionSpinner, 15, not(WebElementMatchers.isDisplayed()));
        fillRadio(settingsTargetRadio, bean.getSettingsModelEnum().getValue(), RadioInputMethod.BY_VALUE);
        makeActionsAfterSpinner(bean);
        fillTextInput(filterNameTextInput, bean.getName());
        switch (bean.getSettingsModelEnum()) {
            case FEED_TREE:
                fillFilterTree(bean.getFeedFilterTree());
                break;
            default:
                fillFilterConditions(bean.getFeedFilterConditions());
                break;
        }
        setCheckboxState(availableCheckbox, bean.getAvailable());
        takeScreenshot();
        clickSaveButton();
        takeScreenshot();
    }

    protected abstract void makeActionsAfterSpinner(FeedFilterBase bean);
}
