package ru.yandex.autotests.direct.web.pages.group.blocks;

import java.util.ArrayList;
import java.util.List;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.data.groupenums.FeedsFilterConditionsField;
import ru.yandex.autotests.direct.web.data.groupenums.IntervalConditions;
import ru.yandex.autotests.direct.web.objects.groups.ConditionRange;
import ru.yandex.autotests.direct.web.objects.groups.feedfilter.FeedFilterCondition;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBlockBEM;
import ru.yandex.autotests.direct.web.webelements.bem.TextAreaBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static ch.lambdaj.Lambda.on;
import static ru.yandex.autotests.direct.httpclient.util.CommonUtils.sleep;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillSelect;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

/**
 * Created by aleran on 25.11.2015.
 */
@FindBy(xpath = ".//div[contains(@class, 'filter-conditions-list__composite-item')]")
public class FilterConditionBlock extends HtmlElement {

    @Name("Удалить условие")
    @FindBy(xpath = ".//div[contains(@class, 'b-control-remove-button')]//button")
    private Button removeCondition;

    @Name("Тип условия")
    @FindBy(xpath = ".//div[contains(@class, 'filter-condition-edit__field-dropdown')]")
    private SelectBlockBEM fieldSelect;

    @Name("Отношение условия")
    @FindBy(xpath = ".//span[contains(@class, 'filter-condition-edit__relation')]//select")
    private SelectBEM relationSelect;

    @Name("Значение условия")
    @FindBy(xpath = ".//span[contains(@class, 'filter-condition-edit-control_type_textarea')]//textarea")
    private TextAreaBEM valueTextArea;

    @Name("Значение условия")
    @FindBy(xpath = ".//div[contains(@class, 'filter-condition-edit-control_type_input-one')]//input")
    private TextAreaBEM valueText;

    private List<FilterConditionRangeBlock> performanceFilterConditionRangeBlocks;

    public void clickRemoveConditionButton() {
        removeCondition.click();
    }

    public FeedsFilterConditionsField getFeedsFilterConditionsField() {
        try {
            Thread.sleep(3000);
            return FeedsFilterConditionsField.getEnumByValue(fieldSelect.getSelectedValue());
        }
        catch (Exception e) {
            throw new DirectWebError("Ошибка при получении фильтра фида");
        }
    }

    public IntervalConditions getIntervalConditions() {
        return IntervalConditions.getEnumByValue(relationSelect.getSelectedValue());
    }

    public String getValue() {
        return WebElementsActions.isDisplayed(valueTextArea) ? valueTextArea.getText() : valueText.getText();
    }

    public List<ConditionRange> getConditionRanges(List<ConditionRange> expectedBean) {
        if (expectedBean == null) {
            return null;
        }
        List<ConditionRange> conditionRanges = new ArrayList<>();
        for (int i = 0; i < performanceFilterConditionRangeBlocks.size(); i++) {
            FilterConditionRangeBlock current = performanceFilterConditionRangeBlocks.get(i);
            conditionRanges.add(current.getFormFieldsAccording(expectedBean.get(i)));
        }
        return conditionRanges;
    }

    private void fillRangeCondition(ConditionRange conditionRange) {
        FilterConditionRangeBlock lastRangeCondition =
                performanceFilterConditionRangeBlocks.get(performanceFilterConditionRangeBlocks.size() - 1);
        if (lastRangeCondition.getMin() != -1) {
            performanceFilterConditionRangeBlocks.get(0).clickAddRangeControlButton();
            lastRangeCondition =
                    performanceFilterConditionRangeBlocks.get(performanceFilterConditionRangeBlocks.size() - 1);
        }
        lastRangeCondition.fillParameters(conditionRange);
    }

    public void fillFieldSelect(FeedFilterCondition bean) {
        fillSelect(fieldSelect, bean.getFeedsFilterConditionsField().getValue(), SelectInputMethod.BY_VALUE);
        sleep(1000);
    }

    public void fillRelationSelect(FeedFilterCondition bean) {
        fillSelect(relationSelect, bean.getIntervalConditions().getValue(), SelectInputMethod.BY_VALUE);
    }

    public void fillValues(FeedFilterCondition bean) {
        switch (bean.getIntervalConditions()) {
            case RANGE:
                performanceFilterConditionRangeBlocks.stream()
                        .forEach(FilterConditionRangeBlock::clickRemoveControlButton);
                bean.getConditionRange().stream().forEach(this::fillRangeCondition);
                break;
            default:
                if (WebElementsActions.isDisplayed(valueTextArea)) {
                    fillTextInput(valueTextArea, bean.getValue());
                } else {
                    fillTextInput(valueText, bean.getValue());
                }

        }
    }

    public FeedFilterCondition getFormFieldsAccording(FeedFilterCondition expectedBean) {
        FeedFilterCondition actualBean = inAccordanceWith(expectedBean).forNew(FeedFilterCondition.class)
                .set("feedsFilterConditionsField", this, on(FilterConditionBlock.class).getFeedsFilterConditionsField())
                .set("intervalConditions", this, on(FilterConditionBlock.class).getIntervalConditions())
                .set("value", this, on(FilterConditionBlock.class).getValue())
                .getActualBean();
        actualBean.setConditionRange(getConditionRanges(expectedBean.getConditionRange()));
        return actualBean;
    }
}
