package ru.yandex.autotests.direct.web.pages.group.blocks;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.groups.ConditionRange;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ch.lambdaj.Lambda.on;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

/**
 * Created by aleran on 25.11.2015.
 */
@FindBy(xpath = ".//div[contains(@class, 'filter-condition-edit-control_type_composite')]")
public class FilterConditionRangeBlock extends HtmlElement {

    @Name("Нижняя граница")
    @FindBy(xpath = ".//span[contains(@class, 'input_name_min')]//input")
    private TextInput minTextInput;

    @Name("Верхняя граница")
    @FindBy(xpath = ".//span[contains(@class, 'input_name_max')]//input")
    private TextInput maxTextInput;

    @Name("Удалить границу")
    @FindBy(xpath = ".//div[contains(@class, 'filter-condition-edit-control__btn-delete-value')]//button")
    private Button removeControl;

    @Name("Добавить границу")
    @FindBy(xpath = ".//div[contains(@class, 'filter-condition-edit-control__btn-add-value')]//button")
    private Button addRangeControl;

    public void clickRemoveControlButton() {
        if (removeControl.isEnabled()) {
            removeControl.click();
        }
    }

    public void clickAddRangeControlButton() {
        if (addRangeControl.isEnabled()) {
            addRangeControl.click();
        }
    }

    public Double getMin() {
        return minTextInput.getText().isEmpty() ? -1 : Double.valueOf(minTextInput.getText());
    }

    public Double getMax() {
        return maxTextInput.getText().isEmpty() ? -1 : Double.valueOf(maxTextInput.getText());
    }

    public void fillParameters(ConditionRange bean) {
        fillTextInput(minTextInput, String.valueOf(bean.getStart()));
        fillTextInput(maxTextInput, String.valueOf(bean.getEnd()));
    }

    public ConditionRange getFormFieldsAccording(ConditionRange expectedBean) {
        return inAccordanceWith(expectedBean).forNew(ConditionRange.class)
                .set("start", this, on(FilterConditionRangeBlock.class).getMin())
                .set("end", this, on(FilterConditionRangeBlock.class).getMax())
                .getActualBean();
    }
}
