package ru.yandex.autotests.direct.web.pages.group.blocks;

import java.util.regex.Pattern;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * Created by aleran on 24.11.2015.
 */
@FindBy(xpath = "//li[contains(@class, 'filters__item')]")
public class FilterItem extends HtmlElement {

    @Name("Ид фильтра")
    @FindBy(xpath = ".//div[contains(@class, 'edit-button')]")
    private WebElement filterId;

    @Name("Редактировать фильтр")
    @FindBy(xpath = ".//div[contains(@class, 'edit-button')]//button")
    private Button editButton;

    @Name("Удалить фильтр")
    @FindBy(xpath = ".//button[contains(@class, 'remove-button__button')]")
    private Button removeButton;

    public String getFilterId() {
        Pattern pattern = Pattern.compile("\"itemId\":[-0-9a-zA-Z\"]*");
        java.util.regex.Matcher matcher = pattern.matcher(filterId.getAttribute("data-bem"));
        if (matcher.find()) {
            return matcher.group().replaceAll("[\":]", "").replace("itemId", "");
        }
        return null;
    }

    public void clickEditButton() {
        editButton.click();
    }

    public void clickRemoveButton() {
        removeButton.click();
    }
}
