package ru.yandex.autotests.direct.web.pages.group.blocks;

import java.util.List;
import java.util.stream.Collectors;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.groups.feedfilter.FeedFilterTree;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.TextAreaBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ch.lambdaj.Lambda.on;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

/**
 * Created by aleran on 08.12.2015.
 */
@FindBy(xpath = "//div[contains(@class, 'filter-target-settings_type_tree')]")
public class FilterTreeBlock extends HtmlElement {

    @Name("Выбрать все")
    @FindBy(xpath = ".//span[contains(@class, 'b-chooser__select-all')]//input")
    CheckBoxBEM selectAll;

    @Name("Элемент дерева")
    @FindBy(xpath = ".//div[contains(@class, 'b-feed-category-tree__item')]//div[contains(@class, 'title-text')]")
    List<WebElement> treeItemTitleList;

    @Name("Элемент дерева")
    @FindBy(xpath = ".//td[contains(@class,'b-feed-category-chooser__right')]//div[@class='b-chooser__title-text']")
    List<WebElement> currentItemList;

    @Name("Убрать элемент из списка")
    @FindBy(xpath = ".//img[contains(@class, 'remove')]")
    List<WebElement> removeItemButtonList;

    @Name("Минимальная цена")
    @FindBy(xpath = ".//span[contains(@class, 'input_name_min')]//input")
    TextInput minTextInput;

    @Name("Максимальная цена")
    @FindBy(xpath = ".//span[contains(@class, 'input_name_max')]//input")
    TextInput maxTextInput;

    @Name("Список производителей")
    @FindBy(xpath = ".//textarea")
    TextAreaBEM vendorsTextArea;

    public List<String> getItemTitles() {
        return currentItemList.stream().map(WebElement::getText).collect(Collectors.toList());
    }

    public Boolean isChooseAll() {
        return selectAll.isSelected();
    }

    private WebElement getTreeItem(String title) {
        WebElement treeItemTitle = treeItemTitleList.stream()
                .filter(t -> t.getText().equals(title))
                .findFirst().orElse(null);
        if (treeItemTitle == null) {
            throw new DirectWebError("Не найден элемент дерева " + title);
        }
        return treeItemTitle;
    }

    public void fillTree(FeedFilterTree filterTree) {
        removeItemButtonList.stream()
                .forEach(WebElement::click);
        if (filterTree.getCategories() != null) {
            filterTree.getCategories().stream()
                    .forEach(t -> getTreeItem(t).click());
        }
        setCheckboxState(selectAll, filterTree.getChooseAll());
        fillTextInput(minTextInput, filterTree.getMin());
        fillTextInput(maxTextInput, filterTree.getMax());
        fillTextInput(vendorsTextArea, filterTree.getVendors());
    }

    public FeedFilterTree getFormFieldsAccording(FeedFilterTree expectedBean) {
        return inAccordanceWith(expectedBean).forNew(FeedFilterTree.class)
                .set("chooseAll", this, on(FilterTreeBlock.class).isChooseAll())
                .set("categories", this, on(FilterTreeBlock.class).getItemTitles())
                .set("min", minTextInput, on(TextInput.class).getText())
                .set("max", maxTextInput, on(TextInput.class).getText())
                .set("vendors", vendorsTextArea, on(TextAreaBEM.class).getText())
                .getActualBean();
    }
}
