package ru.yandex.autotests.direct.web.pages.group.dynamictext;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import org.json.JSONObject;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.BannerPreviewType;
import ru.yandex.autotests.direct.web.data.RadioInputMethod;
import ru.yandex.autotests.direct.web.objects.banners.DynamicTextBannerWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.ContactInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.SiteLinkInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.AddressAndPhoneBlock;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.BannerSiteLinksPopupBlockBEM;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.CalloutsPopup;
import ru.yandex.autotests.direct.web.pages.campaigns.timetarget.elements.Switcher;
import ru.yandex.autotests.direct.web.util.testinterfaces.Checkable;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.qatools.htmlelements.annotations.Name;

import static ch.lambdaj.Lambda.on;
import static ru.yandex.autotests.direct.utils.matchers.BeanEqualsAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillRadio;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanHelper.hasNotNullProperty;
import static ru.yandex.autotests.irt.testutils.beans.BeanFieldsSetter.inAccordanceWith;

/**
 * Created by ssdmitriev on 26.11.15.
 */
@FindBy(xpath = ".//div[contains(@class, 'b-edit-banner2 ')]/parent::div")
public class DynamicTextBannerBlock extends ExtendedHtmlElement implements Checkable<DynamicTextBannerWeb> {
    @Name("id баннера")
    @FindBy(xpath = ".//div[contains(@class, 'b-edit-banner2 ') and contains(@class, 'js_inited')]")
    private WebElement bannerId;

    @Name("Текст объявления")
    @FindBy(xpath = ".//textarea[@name='body']")
    private WebElement bannerBodyText;

    @Name("Открыть попап быстрых ссылок")
    @FindBy(xpath = ".//div[contains(@class,'b-banner-sitelinks__switcher')]//button")
    private WebElement addLinksButton;

    private BannerSiteLinksPopupBlockBEM siteLinksText;

    @Name("Выключатель адреса и телефона")
    @FindBy(xpath = ".//span[contains(@class, 'b-form-switch_type_toggle')]/span")
    private Switcher contactInfoSwitcher;

    @Name("Кнопка добавления текстовых дополнений")
    @FindBy(css = ".b-banner-callouts button")
    private WebElement addCalloutsButton;

    private CalloutsPopup calloutsPopup;

    @Name("Текст дополнений")
    @FindBy(css = ".b-banner-callouts__outcome")
    private WebElement calloutsText;

    @Name("Переключатель вкладки превью")
    @FindBy(xpath = ".//div[contains(@class,'b-banner-preview-filter2')]//input")
    protected RadioBEM previewType;

    @Name("Превью баннера")
    @FindBy(xpath = ".//div[contains(@class,'b-edit-banner2__banner-viewer')]")
    private WebElement bannerPreview;

    public Long getBannerId() {
        String bId = (String) new JSONObject(bannerId.getAttribute("data-bem"))
                .getJSONObject("b-edit-banner2")
                .getJSONObject("modelParams")
                .get("id");
        if (!bId.equals("new1-new1") && !bId.equals("new1")) {
            return new Long(bId);
        } else {
            return new Long(0);
        }
    }

    private void fillBannerText(String text) {
        if (text == null) {
            return;
        }
        bannerBodyText.clear();
        bannerBodyText.sendKeys(text);
    }

    private String getBannerText() {
        return bannerBodyText.getText();
    }

    public WebElement getBannerPreview() {
        return bannerPreview;
    }

    public void clickSiteLinksButton() {
        addLinksButton.click();
    }

    public void clickCalloutsButton() {
        addCalloutsButton.click();
    }

    private void fillSiteLinks(SiteLinkInfoWeb[] sitelinks) {
        if (sitelinks == null) {
            return;
        }
        addLinksButton.click();
        siteLinksText.fillParameters(sitelinks);
    }

    private SiteLinkInfoWeb[] getSiteLinks(SiteLinkInfoWeb[] expectedSiteLinks) {
        if (expectedSiteLinks == null) {
            return null;
        }
        addLinksButton.click();
        return siteLinksText.getFormFieldsAccording(expectedSiteLinks);
    }

    private void fillVcard(ContactInfoWeb contactInfo) {
        if (contactInfo == null) {
            return;
        }
        if (hasNotNullProperty(contactInfo)) {
            contactInfoSwitcher.select();
            addressAndPhoneBlock.fillParameters(contactInfo);
        } else {
            contactInfoSwitcher.deselect();
        }
    }

    private ContactInfoWeb getVcard(ContactInfoWeb expectedBean) {
        return addressAndPhoneBlock.getFormFieldsAccording(expectedBean);
    }

    private void fillCallouts(List<String> callouts) {
        if (callouts == null) {
            return;
        }
        addCalloutsButton.click();
        calloutsPopup.addCallouts(callouts);
        calloutsPopup.clickSave();
    }

    public List<String> getCallouts() {
        if (calloutsText.getText().isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(calloutsText.getText().split(", ")).sorted().collect(Collectors.toList());
    }

    private AddressAndPhoneBlock addressAndPhoneBlock;

    @Override
    public void fillParameters(DynamicTextBannerWeb bean) {
        if (bean == null) {
            return;
        }
        fillBannerText(bean.getText());
        fillSiteLinks(bean.getSitelinks());
        fillVcard(bean.getContactInfo());
        fillCallouts(bean.getCallouts());
    }

    @Override
    public void checkParameters(BeanDifferMatcher<DynamicTextBannerWeb> matcher) {
        assertThat("неверные параметры ДМО группы", getBean(matcher.getExpectedBean()), matcher);
    }

    @Override
    public DynamicTextBannerWeb getBean(DynamicTextBannerWeb expectedBean) {
        DynamicTextBannerWeb dynamicTextBannerWeb = inAccordanceWith(expectedBean).forNew(DynamicTextBannerWeb.class)
                .set("bannerId", this, DynamicTextBannerBlock::getBannerId)
                .set("text", this, DynamicTextBannerBlock::getBannerText)
                .set("callouts", this, on(DynamicTextBannerBlock.class).getCallouts())
                .getActualBean();
        dynamicTextBannerWeb.setContactInfo(expectedBean.getContactInfo());
        dynamicTextBannerWeb.setSitelinks(getSiteLinks(expectedBean.getSitelinks()));
        return dynamicTextBannerWeb;
    }

    public void clickBannerPreviewType(BannerPreviewType prevType) {
        if (previewType == null) {
            return;
        }
        fillRadio(previewType, prevType.toString(), RadioInputMethod.BY_VALUE);
    }

}
