package ru.yandex.autotests.direct.web.pages.group.dynamictext;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.groups.feedfilter.DynamicFeedFilter;
import ru.yandex.autotests.direct.web.objects.groups.feedfilter.FeedFilterBase;
import ru.yandex.autotests.direct.web.pages.group.blocks.EditFilterBlockBase;
import ru.yandex.autotests.direct.web.webelements.NumericInput;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.qatools.htmlelements.annotations.Name;

import static ch.lambdaj.Lambda.on;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

public class EditDynamicFilterBlock extends EditFilterBlockBase {
    @Name("Цена за клик")
    @FindBy(xpath = ".//span[contains(@class, 'b-feed-filter-edit__price-input')]//input")
    NumericInput priceInput;

    public DynamicFeedFilter getFormFieldsAccording(DynamicFeedFilter expectedBean) {
        return inAccordanceWith(expectedBean)
                .forExisting((DynamicFeedFilter) getFormFieldsAccording(expectedBean, new DynamicFeedFilter()))
                .set("price", this, on(EditDynamicFilterBlock.class).getPrice())
                .getActualBean();
    }

    public void checkParameters(BeanDifferMatcher<DynamicFeedFilter> matcher) {
        DynamicFeedFilter filter = matcher.getExpectedBean();
        assertThat("параметры фильтра верны", getFormFieldsAccording(filter), matcher);
    }

    public Double getPrice() {
        return Double.valueOf(priceInput.getValue());
    }

    @Override
    protected void makeActionsAfterSpinner(FeedFilterBase bean) {
        DynamicFeedFilter actualFilter = (DynamicFeedFilter) bean;
        if (actualFilter.getPrice() != null) {
            fillTextInput(priceInput, String.valueOf(actualFilter.getPrice()));
        }
    }
}
