package ru.yandex.autotests.direct.web.pages.group.performance;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.data.groupenums.TargetAudienceEnum;
import ru.yandex.autotests.direct.web.objects.groups.feedfilter.FeedFilterBase;
import ru.yandex.autotests.direct.web.objects.groups.feedfilter.PerformanceFeedFilter;
import ru.yandex.autotests.direct.web.pages.group.blocks.EditFilterBlockBase;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ch.lambdaj.Lambda.on;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillSelect;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by aleran on 24.11.2015.
 */
public class EditPerformanceFilterBlock extends EditFilterBlockBase {

    @Name("CPC")
    @FindBy(xpath = ".//span[contains(@data-bem,'price_cpc')]//input")
    private TextInput priceCpcTextInput;

    @Name("Целевая аудитория")
    @FindBy(xpath = ".//span[contains(@class,'b-feed-filter-target-funnel')]//select")
    private SelectBEM targetFunnelSelect;

    public Double getPriceCpc() {
        return Double.valueOf(priceCpcTextInput.getText());
    }

    public TargetAudienceEnum getTargetFunnel() {
        return TargetAudienceEnum.getEnumByValue(targetFunnelSelect.getSelectedValue());
    }

    public PerformanceFeedFilter getFormFieldsAccording(PerformanceFeedFilter expectedBean) {
        return inAccordanceWith(expectedBean)
                .forExisting((PerformanceFeedFilter) getFormFieldsAccording(expectedBean, new PerformanceFeedFilter()))
                .set("priceCpc", this, on(EditPerformanceFilterBlock.class).getPriceCpc())
                .set("targetAudienceEnum", this, on(EditPerformanceFilterBlock.class).getTargetFunnel())
                .getActualBean();
    }

    public void checkParameters(BeanDifferMatcher<PerformanceFeedFilter> matcher) {
        PerformanceFeedFilter filter = matcher.getExpectedBean();
        assertThat("параметры фильтра верны", getFormFieldsAccording(filter), matcher);
    }

    @Override
    protected void makeActionsAfterSpinner(FeedFilterBase bean) {
        PerformanceFeedFilter actualBean = (PerformanceFeedFilter) bean;
        if (actualBean.getPriceCpc() != null) {
            fillTextInput(priceCpcTextInput, String.valueOf(actualBean.getPriceCpc()));
        }
        fillSelect(targetFunnelSelect, actualBean.getTargetAudienceEnum().getValue(), SelectInputMethod.BY_VALUE);
    }
}
