package ru.yandex.autotests.direct.web.pages.group.performance;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.objects.adjustment.rates.HierarchicalMultipliersWeb;
import ru.yandex.autotests.direct.web.objects.banners.PerformanceBannerWeb;
import ru.yandex.autotests.direct.web.objects.groups.PerformanceGroupWeb;
import ru.yandex.autotests.direct.web.objects.groups.feedfilter.PerformanceFeedFilter;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.peformance.CreativeBlock;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.peformance.PerformanceBannerBlock;
import ru.yandex.autotests.direct.web.pages.group.GroupBaseBlock;
import ru.yandex.autotests.direct.web.pages.group.blocks.EditFilterBlockBase;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.testinterfaces.Checkable;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBlockBEM;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import java.util.List;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.httpclient.util.beanmapper.BeanMapper.map;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillSelect;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

/**
 * Created by aleran on 24.11.2015.
 */
@FindBy(xpath = ".//div[contains(@class, 'b-edit-group ')]")
public class EditPerformanceGroupWithBannerBlock extends GroupBaseBlock implements Checkable<PerformanceGroupWeb> {

    @Name("Серектор фида")
    @FindBy(xpath = ".//div[contains(@class, 'group__feed')]")
    private SelectBlockBEM groupFeed;

    List<PerformanceBannerBlock> performanceBannerBlocks;

    private CreativeBlock creativeBlock;

    @Name("Добавить баннер")
    @FindBy(xpath = ".//button[contains(@class,'add-button')]")
    private Button addBannerButton;

    @Name("Кнопка 'задать' минус-слова на группу")
    @FindBy(xpath = ".//div[contains(@class, 'b-minus-words-control__switcher ')]/button")
    private Button minusWordsButton;

    @Name("Кнопка 'уточнить' регионы показа")
    @FindBy(xpath = ".//div[contains(@class, 'b-regions-selector')]//button")
    private Button regionsButton;

    @Name("Кнопка 'изменить' корректировки ставок")
    @FindBy(css = "div.b-adjustment-rates-popup button")
    private Button adjustmentRatesButton;

    private EditPerformanceFilterBlock performanceFilterBlock;

    public PerformanceBannerBlock getBannerBlock(Long bannerId) {
        PerformanceBannerBlock block = performanceBannerBlocks.stream()
                .filter(t -> t.getBannerId().equals(bannerId))
                .findFirst().orElseThrow(() -> new DirectWebError("Блок баннера " + bannerId + " не найден"));
        block.setConfig(config);
        return block;
    }

    public void fillBannerParametersUsingListMode(PerformanceBannerWeb baseBannerWeb) {
        Long creativeId = baseBannerWeb.getCreative().getCreativeId();
        creativeBlock.setConfig(config);
        if (baseBannerWeb.getBannerId() == 0) {
            addBannerButton.click();
            creativeBlock.selectNewCreative(creativeId);
        } else {
            PerformanceBannerBlock performanceBannerBlock = getBannerBlock(baseBannerWeb.getBannerId());
            performanceBannerBlock.clickEditButton();
            creativeBlock.editCreative(creativeId);
        }
        waitForElement(creativeBlock, 10, not(WebElementMatchers.isDisplayed()));
    }

    public void checkBannerParameters(BeanDifferMatcher<PerformanceBannerWeb> matcher) {
        PerformanceBannerBlock bannerBlock = getBannerBlock(matcher.getExpectedBean().getBannerId());
        bannerBlock.checkParameters(matcher);
    }
    
    @Override
    public void fillParameters(PerformanceGroupWeb bean) {
        super.fillParameters(bean);
        if (bean.getAdGroupId() == 0) {
            fillSelect(groupFeed, bean.getFeedId(), SelectInputMethod.BY_VALUE);
        }
        fillFilter(bean.getFeedFilters());
    }

    @Override
    public void checkParameters(BeanDifferMatcher<PerformanceGroupWeb> matcher) {
        PerformanceGroupWeb expectedBean = matcher.getExpectedBean();
        assertThat("параметры Смарт группы соответствуют ожидаемым", getBean(expectedBean), matcher);
    }

    @Override
    public void checkHierarchicalMultipliersParameters(HierarchicalMultipliersWeb hierarchicalMultipliers) {
        if (hierarchicalMultipliers == null) {
            return;
        }
        super.checkHierarchicalMultipliersParameters(hierarchicalMultipliers);
    }

    @Override
    public PerformanceGroupWeb getBean(PerformanceGroupWeb expectedBean) {
        PerformanceGroupWeb actualBean = inAccordanceWith(expectedBean)
                .forExisting(map(super.getBean(expectedBean), PerformanceGroupWeb.class))
                .getActualBean();
        actualBean.setFeedId(expectedBean.getFeedId());
        actualBean.setFeedFilters((List<PerformanceFeedFilter>) getFeedFilters(expectedBean.getFeedFilters()));
        return actualBean;
    }

    public void openMinusWordsPopup() {
        minusWordsButton.click();
    }

    public void openRegionsPopup() {
        regionsButton.click();
    }

    public void openAdjustmentRatesPopup() {
        adjustmentRatesButton.click();
    }

    @Override
    protected EditFilterBlockBase getFilterBlock() {
        return performanceFilterBlock;
    }
}