package ru.yandex.autotests.direct.web.pages.managers;

import org.hamcrest.Matcher;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Select;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillSelect;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

/**
 * Created with IntelliJ IDEA.
 * User: alex-samo
 * Date: 16.11.13
 * Time: 20:39
 * To change this template use File | Settings | File Templates.
 */

@NamedUrls({
        @NamedUrl(name = "open.show.add.agency", url = "/registered/main.pl?cmd=admShowAddAgency")
})
public class AdmShowAddAgencyPage extends BasePageObject implements IWebFrom<AccountWeb> {


    @Name("Логин")
    @FindBy(xpath = ".//input[@name='login']")
    private TextInput loginTextInput;

    @Name("Название")
    @FindBy(xpath = ".//input[@name='name']")
    private TextInput nameTextInput;

    @Name("Страна")
    @FindBy(xpath = ".//select[@class='b-choose-country__select']")
    private Select countrySelect;

    @Name("Телефон")
    @FindBy(xpath = ".//input[@name='phone']")
    private TextInput phoneTextInput;

    @Name("WEB")
    @FindBy(xpath = ".//input[@name='url']")
    private TextInput urlTextInput;

    @Name("E-mail")
    @FindBy(xpath = ".//input[@name='email']")
    private TextInput emailTextInput;

    @Name("Город")
    @FindBy(xpath = ".//input[@name='city']")
    private TextInput cityTextInput;

    @Name("Найти")
    @FindBy(xpath = ".//input[@name='sbm_find']")
    private WebElement findButton;

    @Name("Красная надпись")
    @FindBy(xpath = "//div[contains(@style, 'color: Red')]")
    private WebElement message;

    @Override
    public void fillParameters(AccountWeb accountWeb) {
        fillTextInput(loginTextInput, accountWeb.getLogin());
        fillTextInput(nameTextInput, accountWeb.getName());
        fillSelect(countrySelect, accountWeb.getCountry(), SelectInputMethod.BY_TEXT);
        fillTextInput(phoneTextInput, accountWeb.getPhone());
        fillTextInput(urlTextInput, accountWeb.getUrl());
        fillTextInput(emailTextInput, accountWeb.getEmail());
        new WebElementsActions(config).fillTextInputWithClickAndEvents(cityTextInput, accountWeb.getCity());
    }

    @Override
    public void checkParameters(AccountWeb expectedBean) {
        assertThat("неверные параметры бина ", getFormFieldsAccording(expectedBean), beanEquals(expectedBean));
    }

    @Override
    public AccountWeb getFormFieldsAccording(
            AccountWeb expectedBean) {
        AccountWeb accountWeb =
                inAccordanceWith(expectedBean).forNew(AccountWeb.class)
                        .set("login", loginTextInput, on(TextInput.class).getText())
                        .set("name", nameTextInput, on(TextInput.class).getText())
                        .set("country", countrySelect, on(Select.class).getFirstSelectedOption().getText())
                        .set("phone", phoneTextInput, on(TextInput.class).getText())
                        .set("url", urlTextInput, on(TextInput.class).getText())
                        .set("email", emailTextInput, on(TextInput.class).getText())
                        .set("city", cityTextInput, on(TextInput.class).getText())
                        .getActualBean();
        return accountWeb;
    }

    public void clickOnFindButton() {
        ((JavascriptExecutor)config.getDriver()).executeScript("$(arguments[0]).click();", findButton);
    }

    public void shouldSeeMessage(Matcher<WebElement> matcher) {
        waitForElement(message, 100, matcher);
    }
}
