package ru.yandex.autotests.direct.web.pages.managers;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.objects.campaigns.CopyCampaignInfoWeb;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.Select;
import ru.yandex.qatools.htmlelements.element.TextInput;

import java.util.List;
import java.util.stream.Collectors;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.*;

/**
 * Author buhter
 * Date 26.05.14
 */
@NamedUrls({
        @NamedUrl(name = CopyCampPage.PAGE_NAME, url = "/registered/main.pl?cmd=copyCamp")
})
public class CopyCampPage extends BasePageObject implements IWebFrom<CopyCampaignInfoWeb> {

    public static final String PAGE_NAME = "open.copy.campaign";

    //region Elements
    @Name("Поле номера кампании")
    @FindBy(xpath = ".//input[@name = 'cid_from']")
    private TextInput campaignIdInput;

    @Name("Поле старого логина")
    @FindBy(xpath = ".//input[@name = 'oldlogin']")
    private TextInput fromLoginInput;

    @Name("Поле нового логина")
    @FindBy(xpath = ".//input[@name = 'newlogin']")
    private TextInput toLoginInput;

    @Name("Чекбокс копирования CTR")
    @FindBy(xpath = ".//input[@id = 'copy_ctr']")
    private CheckBox copyCTRCheckbox;

    @Name("Чекбокс копирования остановленных баннеров")
    @FindBy(xpath = ".//input[@id = 'copy_stopped']")
    private CheckBox copyStoppedBannersCheckbox;

    @Name("Чекбокс копирования архивированных баннеров")
    @FindBy(xpath = ".//input[@id = 'copy_archived']")
    private CheckBox copyArchivedBannersCheckbox;

    @Name("Чекбокс копирования статусов баннеров")
    @FindBy(xpath = ".//input[@id = 'copy_moderate_status']")
    private CheckBox copyBannersStatusesCheckbox;

    @Name("Чекбокс статусов фраз")
    @FindBy(xpath = ".//input[@id = 'copy_phrase_status']")
    private CheckBox copyPhrasesStatusesCheckbox;

    @Name("Кнопка копирования кампании")
    @FindBy(xpath = ".//input[@type = 'submit']")
    private Button copyButton;

    @Name("Выбор типа обслуживания")
    @FindBy(xpath = ".//select[@id = 'for_agency']")
    private Select servicingTypeSelect;

    @Name("Поле причины копирования")
    @FindBy(xpath = ".//input[@name = 'reason']")
    private TextInput reasonInput;

    @Name("Текст ошибки")
    @FindBy(xpath = ".//small[@style = 'color: red;']")
    private WebElement errorTextElement;

    @Name("Текст предупреждения о смене валюты")
    @FindBy(xpath = ".//table/tbody/tr/td/p[@style = 'color: red;']")
    private WebElement currencyWarningTextElement;

    @Name("Текст при успешном копировании")
    @FindBy(xpath = ".//div[@style = 'color: green;']")
    private WebElement successMessageElement;

    //endregion

    //region Getters
    public TextInput getCampaignIdInput() {
        return campaignIdInput;
    }

    public TextInput getFromLoginInput() {
        return fromLoginInput;
    }

    public TextInput getToLoginInput() {
        return toLoginInput;
    }

    public CheckBox getCopyCTRCheckbox() {
        return copyCTRCheckbox;
    }

    public CheckBox getCopyStoppedBannersCheckbox() {
        return copyStoppedBannersCheckbox;
    }

    public CheckBox getCopyArchivedBannersCheckbox() {
        return copyArchivedBannersCheckbox;
    }

    public CheckBox getCopyBannersStatusesCheckbox() {
        return copyBannersStatusesCheckbox;
    }

    public CheckBox getCopyPhrasesStatusesCheckbox() {
        return copyPhrasesStatusesCheckbox;
    }

    public Button getCopyButton() {
        return copyButton;
    }

    public Select getServicingTypeSelect() {
        return servicingTypeSelect;
    }

    public TextInput getReasonInput() {
        return reasonInput;
    }

    public WebElement getErrorTextElement() {
        return errorTextElement;
    }

    public WebElement getCurrencyWarningTextElement() {
        return currencyWarningTextElement;
    }

    public String getErrorText() {
        return getErrorTextElement().getText();
    }

    public WebElement getSuccessMessageElement() {
        return successMessageElement;
    }

    public String getSuccessMessage() {
        return getSuccessMessageElement().getText();
    }

    public String getCurrencyWarning() {
        return getCurrencyWarningTextElement().getText();
    }
    //endregion

    //region Actions

    @Override
    public void fillParameters(CopyCampaignInfoWeb copyCampaignInfoWeb) {
        fillCampaignIds(copyCampaignInfoWeb.getCampaignsForCopy());
        fillTextInput(getFromLoginInput(), copyCampaignInfoWeb.getFromUser().getLogin());
        fillTextInput(getToLoginInput(), copyCampaignInfoWeb.getToUser().getLogin());
        setCheckboxState(getCopyArchivedBannersCheckbox(), copyCampaignInfoWeb.isCopyArchivedBanners());
        setCheckboxState(getCopyStoppedBannersCheckbox(), copyCampaignInfoWeb.isCopyStoppedBanners());
        setCheckboxState(getCopyBannersStatusesCheckbox(), copyCampaignInfoWeb.isCopyBannersStatuses());
        setCheckboxState(getCopyPhrasesStatusesCheckbox(), copyCampaignInfoWeb.isCopyPhrasesStatuses());
        setCheckboxState(getCopyCTRCheckbox(), copyCampaignInfoWeb.isCopyCTR());
        fillTextInput(getReasonInput(), copyCampaignInfoWeb.getReason());
    }

    //No need for this form
    @Override
    public void checkParameters(CopyCampaignInfoWeb expectedBean) {
    }

    //No need for this form
    @Override
    public CopyCampaignInfoWeb getFormFieldsAccording(CopyCampaignInfoWeb expectedBean) {
        return null;
    }

    public void fillCampaignIds(List<String> campaignIdList) {
        fillTextInput(getCampaignIdInput(), campaignIdList.stream().collect(Collectors.joining(", ")));
    }

    public void clickCopyButton() {
        getCopyButton().click();
    }

    public void selectServicingType(String value) {
        getServicingTypeSelect().selectByValue(value);
    }

    //endregion

    //region Assertions

    public void checkErrorText(Matcher<String> matcher) {
        assertThat(getErrorText(), matcher);
    }

    public void checkSuccessMessageDisplayed() {
        isDisplayed(getSuccessMessageElement());
    }

    public void checkSuccessMessage(Matcher<String> matcher) {
        assertThat(getSuccessMessage(), matcher);
    }

    public void checkCurrencyWarningText(Matcher<String> matcher) {
        assertThat(getCurrencyWarning(), matcher);
    }

    public void checkServicingTypeSelectDisplayed() {
        isDisplayed(getServicingTypeSelect());
    }


    //endregion
}
