package ru.yandex.autotests.direct.web.pages.mediaplans;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.regionselectpopup.RegionSelectPopupBlock;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

/**
 * User: alexey-n
 * Date: 26.08.13
 * Time: 16:48
 */
public class CreateMediaplanPage extends BasePageObject {

    @Name("Кнопка смены региона")
    @FindBy(xpath = ".//span[contains(@class, 'region-selector')]//input")
    private Button changeRegion;

    @Name("Кнопка далее")
    @FindBy(xpath = ".//div[contains(@class, 'buttons')]//input[@type = 'submit']")
    private Button nextButton;

    @Name("")
    @FindBy(xpath = ".//span[contains(@class, 'region-select')]/input")
    private WebElement selectRegionButton;

    private RegionSelectPopupBlock regionSelectPopupBlock;

    public void fillRegions(String geo) {
        if (geo == null)
            return;
        selectRegionButton.click();
        regionSelectPopupBlock.fillRegions(geo);
    }


    public void clickChangeRegion() {
        changeRegion.click();
    }

    public void clickNextButton() {
        nextButton.click();
    }
}
