package ru.yandex.autotests.direct.web.pages.mediaplans;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.banners.OptimizedPhraseInfoWeb;
import ru.yandex.autotests.direct.web.pages.mediaplans.blocks.MediaplanPhrasesBlock;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * User: alexey-n
 * Date: 26.08.13
 * Time: 16:56
 */
public class MultiEditMediaplanPage2 extends BasePageObject {

    @Name("Кнопка сохранить")
    @FindBy(xpath = ".//span[contains(@class, '__submit ')]//input")
    private Button saveButton;

    @Name("Кнопка назад")
    @FindBy(xpath = ".//span[contains(@class, '__submit-back')]//input")
    private Button prevButton;

    @Name("Подставить цену объёма трафика 100")
    @FindBy(xpath = ".//span[contains(@class, 'group-operations__link_val_10')]")
    private WebElement setTrafficValue100;

    @Name("Подставить цену объёма трафика 5")
    @FindBy(xpath = ".//span[contains(@class, 'group-operations__link_val_23')]")
    private WebElement setTrafficValue5;

    protected MediaplanPhrasesBlock mediaplanPhrasesBlock;

    public void clickSetTrafficValue100() {
        setTrafficValue100.click();
    }

    public void clickSetTrafficValue5() {
        setTrafficValue5.click();
    }

    public void clickSaveButton() {
        saveButton.click();
    }

    public void checkSaveButton(Matcher matcher) {
        assertThat(saveButton, matcher);
    }

    public void clickPrevButton() {
        prevButton.click();
    }

    public void fillPhraseParameters(OptimizedPhraseInfoWeb phrase) {
        mediaplanPhrasesBlock.fillParameters(phrase);
    }

    public void checkPhraseParameters(OptimizedPhraseInfoWeb phrase) {
        mediaplanPhrasesBlock.checkParameters(phrase);
    }

    public Long getOptimizedBannerIDFor(Long bannerId) {
        return mediaplanPhrasesBlock.getOptimizedBannerID(bannerId);
    }

    public OptimizedPhraseInfoWeb getPhraseInfo(OptimizedPhraseInfoWeb phrase) {
        return mediaplanPhrasesBlock.getFormFieldsAccording(phrase);
    }

    public void declinePhrase(OptimizedPhraseInfoWeb phrase) {
        mediaplanPhrasesBlock.declinePhrase(phrase);
    }

    public void selectPhrase(OptimizedPhraseInfoWeb phrase, boolean state) {
        mediaplanPhrasesBlock.setPhraseCheckBox(phrase, state);
    }

    public void checkPhraseNotVisible(OptimizedPhraseInfoWeb phrase) {
        mediaplanPhrasesBlock.checkPhraseNotVisible(phrase);
    }
}
