package ru.yandex.autotests.direct.web.pages.mediaplans;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.mediaplan.RequestMediaplanInfo;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.Select;
import ru.yandex.qatools.htmlelements.element.TextInput;

/**
 * Created with IntelliJ IDEA.
 * User: alexey-n
 * Date: 03.12.13
 * Time: 14:29
 * To change this template use File | Settings | File Templates.
 */
public class SendRequestMediaplanPage extends BasePageObject {


    @Name("Поле Кому")
    @FindBy(xpath = ".//input[@name = 'mailto']")
    private TextInput mailToInput;

    @Name("Тип заявки")
    @FindBy(xpath = ".//select[@name = 'typeMedia']")
    private Select requestTypeSelect;

    @Name("Месячный бюджет")
    @FindBy(xpath = ".//input[@name = 'budget']")
    private TextInput montlyBudgetInput;

    @Name("Цели кампании")
    @FindBy(xpath = ".//textarea[@name = 'target_camp']")
    private TextInput campaignTargetInput;

    @Name("Целевая аудитория")
    @FindBy(xpath = ".//select[@name = 'target']")
    private Select requestTargetSelect;

    @Name("Кнопка отправить")
    @FindBy(xpath = ".//div/input[@type = 'submit']")
    private Button sendRequest;

    public void fillRequestParameters(RequestMediaplanInfo requestMediaplanInfo) {
        fillCampaignTarget(requestMediaplanInfo.getTargetCamp());
        fillMailTo(requestMediaplanInfo.getMailTo());
        fillMontlyBudget(requestMediaplanInfo.getBudget());
        fillRequestTarget(requestMediaplanInfo.getTarget());
        fillRequestType(requestMediaplanInfo.getTypeMedia());
    }

    private void fillMailTo(String mailto) {
        if (mailto == null) {
            return;
        }
        mailToInput.clear();
        mailToInput.sendKeys(mailto);
    }

    private void fillRequestType(String requestType) {
        if (requestType == null) {
            return;
        }
        requestTypeSelect.selectByValue(requestType);
    }

    private void fillCampaignTarget(String campaignTarget) {
        if (campaignTarget == null) {
            return;
        }
        campaignTargetInput.clear();
        campaignTargetInput.sendKeys(campaignTarget);
    }

    private void fillRequestTarget(String requestTarget) {
        if (requestTarget == null) {
            return;
        }
        requestTargetSelect.selectByValue(requestTarget);
    }

    private void fillMontlyBudget(String montlyBudget) {
        if (montlyBudget == null) {
            return;
        }
        montlyBudgetInput.clear();
        montlyBudgetInput.sendKeys(montlyBudget);
    }

    public void sendRequest() {
        sendRequest.click();
    }
}
