package ru.yandex.autotests.direct.web.pages.mediaplans.blocks;

import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.baseblocks.EditBannerBaseBlock;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.getVisibleElement;

/**
 * User: alexey-n
 * Date: 26.08.13
 * Time: 16:59
 */
@FindBy(xpath = ".//div[starts-with(@id, '" + EditMediaplanBlock.BANNER_ID_PREFIX + "')]")
public class EditMediaplanBlock extends EditBannerBaseBlock {


    @Name("Чекбокс адреса и телефона")
    @FindBy(xpath = ".//input[contains(@id, 'banner_with_phone_cbx')]")
    private CheckBox contactInfoCheckBox;

    @Name("Чекбокс ссылки на сайт")
    @FindBy(xpath = ".//input[contains(@id, 'with_href_')]")
    private CheckBox hrefCheckBox;

    @Name("Ссылка показать/скрыть домен")
    @FindBy(xpath = ".//a[contains(@id, 'a_domain_strict')]")
    private WebElement domainStrict;

    @Name("")
    @FindBy(xpath = ".//input[contains(@class, 'banner-form-href__domain-input')]")
    private TextInput domain;

    private EditPhrasesBlock phraseBlock;

    protected List<PhrasesActionPopupBlock> phrasesActionPopups;

    @Override
    protected void contactInfoSetEnabled(boolean enabled) {
        if (enabled) {
            contactInfoCheckBox.select();
        } else {
            contactInfoCheckBox.deselect();
        }
    }

    @Override
    protected void fillPhrases(BannerPhraseInfoWeb[] phrases) {
        if (phrases == null) {
            return;
        }
        openPhraseActionPopup();
        PhrasesActionPopupBlock phrasesActionPopupBlock = getVisibleElement(phrasesActionPopups);
        if (phrasesActionPopupBlock == null) {
            throw new DirectWebError("Не найден попап с действиями над фразами");
        }
        phrasesActionPopupBlock.clickRemoveAllPhrases();
        phraseBlock.fillParameters(phrases);
    }

    protected void checkPhrases(BannerPhraseInfoWeb[] phrases) {
        if (phrases == null) {
            return;
        }
        phraseBlock.checkParameters(phrases);
    }

    public void openPhraseActionPopup() {
        phraseBlock.openPhraseActionPopup();
    }

    public void checkPhraseList(Matcher matcher) {
        phraseBlock.checkPhraseList(matcher);
    }

    @Override
    public void checkParameters(BannerInfoWeb expectedBean) {
        super.checkParameters(expectedBean);
        checkPhrases(expectedBean.getPhrases());
    }

    public void clickAdjustPhrase(String phrase) {
        phraseBlock.clickAdjustPhrase(phrase);
    }

    public void clickChoosePhrase(String phrase) {
        phraseBlock.clickChoosePhrase(phrase);
    }

    public void checkDomainName(String domain) {
        domainStrict.click();
        assertThat("домен не соответствует ожиданиям", this.domain.getText(), equalTo(domain));
    }

    public void clickOnClearPhrasesTextInput() {
        phraseBlock.clickOnClearButton();
    }
}
