package ru.yandex.autotests.direct.web.pages.mediaplans.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

/**
 * User: alexey-n
 * Date: 11.09.13
 * Time: 16:34
 */
@FindBy(xpath = ".//div[contains(@class, 'mediaplan-form-phrases-splited')]/div//table")
public class EditPhraseRowBlock extends HtmlElement {

    @Name("Кнопка удалить")
    @FindBy(xpath = ".//a[contains(@class, '__delete')]")
    private WebElement deleteButton;

    @Name("Поле для ввода фразы")
    @FindBy(xpath = ".//td[contains(@class, '__input')]/input")
    private WebElement phraseInput;

    @Name("Кнопка уточинить")
    @FindBy(xpath = ".//a[contains(@class, '__adjust')]")
    private Link adjustLink;

    @Name("Кнопка подобрать")
    @FindBy(xpath = ".//a[contains(@class, '__select')]")
    private Link selectLink;

    public String getPhraseInputText() {
        return phraseInput.getAttribute("value");
    }

    public void setPhraseInputText(String text) {
        phraseInput.clear();
        phraseInput.sendKeys(text);
    }

    public void clickAdjust() {
        adjustLink.click();
    }

    public void clickSelect() {
        selectLink.click();
    }
}
