package ru.yandex.autotests.direct.web.pages.mediaplans.blocks;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static java.util.stream.Collectors.toList;
import static org.hamcrest.Matchers.hasItems;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.web.util.OperationSystemUtils.sleep;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;

/**
 * User: alexey-n
 * Date: 11.09.13
 * Time: 16:33
 */
@FindBy(xpath = ".//tbody[contains(@class, 'mediaplan-form-phrases')]")
public class EditPhrasesBlock extends HtmlElement {

    @Name("Фразы")
    @FindBy(id = "ad-words")
    private TextInput phrases;

    @Name("Разбить фразы по словам")
    @FindBy(xpath = ".//input[@id = 'split_words']")
    private Button splitPhraseButton;

    @Name("Очистить")
    @FindBy(xpath = ".//input[@id = 'clear_words']")
    private Button clearButton;

    @Name("Действия с фразами")
    @FindBy(xpath = ".//div[contains(@class,'phrases-mass')]/div/span/span")
    private WebElement phraseActionButton;

    protected List<EditPhraseRowBlock> phraseRowList;

    public void checkPhraseList(Matcher matcher) {
        List<String> phrases = getPhrases();
        assertThat("список фраз не соответствует ожиданиям.", phrases, should(matcher).whileWaitingUntil(
                timeoutHasExpired(TimeUnit.SECONDS.toMillis(
                        DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()))));
    }

    private List<String> getPhrases() {
        List<String> phrases = phraseRowList.stream().map(EditPhraseRowBlock::getPhraseInputText).collect(toList());
        return phrases;
    }

    public void checkParameters(BannerPhraseInfoWeb[] expectedBean) {
        List<String> exceptedPhrases = extract(Arrays.asList(expectedBean),
                on(BannerPhraseInfoWeb.class).getPhrase());
        checkPhraseList(hasItems(exceptedPhrases.toArray(new String[exceptedPhrases.size()])));

    }

    public void fillParameters(BannerPhraseInfoWeb[] bean) {
        if (phrases == null)
            return;
        List<String> phraseList = Stream.of(bean).map(x -> x.getPhrase()).collect(toList());
        phrases.clear();
        phrases.sendKeys(StringUtils.join(phraseList, ", "));
        splitPhraseButton.click();
        sleep(TimeUnit.SECONDS.toMillis(DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()));
    }

    public void openPhraseActionPopup() {
        phraseActionButton.click();
    }

    public void clickAdjustPhrase(String phrase) {
        if (phrase == null) {
            return;
        }
        for (EditPhraseRowBlock phraseRow : phraseRowList) {
            if (phraseRow.getPhraseInputText().equals(phrase)) {
                phraseRow.clickAdjust();
                return;
            }
        }
        throw new DirectWebError("Строка с указанной фразой не найдена");
    }

    public void clickChoosePhrase(String phrase) {
        if (phrase == null) {
            return;
        }
        for (EditPhraseRowBlock phraseRow : phraseRowList) {
            if (phraseRow.getPhraseInputText().equals(phrase)) {
                phraseRow.clickSelect();
                return;
            }
        }
        throw new DirectWebError("Строка с указанной фразой не найдена");
    }

    public void clickOnClearButton() {
        clearButton.click();
    }
}
