package ru.yandex.autotests.direct.web.pages.mediaplans.blocks;

import java.util.List;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.banners.GroupChangesBlockTabs;
import ru.yandex.autotests.direct.web.data.banners.GroupChangesInfo;
import ru.yandex.autotests.direct.web.data.textresources.EditBannerResource;
import ru.yandex.autotests.direct.web.objects.banners.commons.SiteLinkInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.BannerSiteLinksPopupBlock;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.autotests.direct.web.webelements.TabbedPane;
import ru.yandex.qatools.allure.webdriver.steps.AlertSteps;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.Select;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillHrefWithScheme;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@FindBy(xpath = "//div[contains(@class, 'b-banner-form__multiedit_long')]")
public class GroupChangesBlock extends ExtendedHtmlElement {

    private AlertSteps onAlert() {
        return BaseSteps.getInstance(AlertSteps.class, config);
    }

    @FindBy(xpath = ".//div[contains(@class, 'b-tabbed-pane__tabs')]")
    public TabbedPane tabs;

    @Name("Новая ссылка на вкладке 'Ссылка на сайт'")
    @FindBy(xpath = ".//input[@id='b-bfm__new-href']")
    public TextInput newSiteLink;

    @Name("Протокол новой ссылки на вкладке 'Ссылка на сайт'")
    @FindBy(css = "select.b-bfm__new-href-protocol")
    public Select newSitelinkschemeSelect;

    @Name("Поле 'Найти' на вкладке 'Часть ссылки'")
    @FindBy(id = "b-bfm__href-from")
    public TextInput linkPartFindBy;

    @Name("Поле 'Заменить на' на вкладке 'Часть ссылки'")
    @FindBy(id = "b-bfm__href-to")
    public TextInput linkPartReplaceWith;

    @Name("Поле 'Новый домен' на вкладке 'Домен'")
    @FindBy(id = "b-bfm__new-domain")
    public TextInput newDomain;

    @Name("Поле 'Добавить' на вкладке 'Минус слова'")
    @FindBy(id = "b-bfm__add-text")
    public TextInput minusKeywords;

    @Name("'Исправлять быстрые ссылки на вкладке 'Часть ссылки''")
    @FindBy(id = "b-bfm__update-sitelinks")
    public CheckBox fixQuickLinks;

    @Name("Поле 'Найти' на вкладке 'Часть текста'")
    @FindBy(id = "b-bfm__text-from")
    public TextInput bodyPartFindBy;

    @Name("Поле 'Заменить на' на вкладке 'Часть текста'")
    @FindBy(id = "b-bfm__text-to")
    public TextInput bodyPartReplaceWith;

    @Name("Вкладка 'Быстрые ссылки'")
    @FindBy(xpath = ".//div[@class = 'b-tabbed-pane__panel b-tabbed-pane__panel_state_current']")
    public BannerSiteLinksPopupBlock linksPopupBlock;

    @Name("'Изменить ссылку на вкладке 'Ссылка на сайт'")
    @FindBy(xpath = ".//span[contains(@class, 'replace-href')]/input")
    public Button replaceHrefButton;

    @Name("'Изменить часть ссылки' на вкладке 'Часть ссылки'")
    @FindBy(xpath = ".//span[contains(@class, 'update-href')]/input")
    public Button updateHrefButton;

    @Name("Изменить часть текста на вкладке 'Часть тектса'")
    @FindBy(xpath = ".//span[contains(@class, 'update-text')]/input")
    public Button updateTextButton;

    @Name("Изменить бысрые ссылки на вкладке 'Быстрые ссылки'")
    @FindBy(xpath = ".//span[contains(@class, 'add-sitelinks')]/input")
    public Button addSiteLinksButton;

    @Name("'Изменить минус слова' на вкладке 'Минус слова'")
    @FindBy(xpath = ".//span[contains(@class, 'add-minus-words')]/input")
    public Button addMinusWordsButton;

    @Name("Изменить домен на вкладке 'Домен'")
    @FindBy(xpath = ".//span[contains(@class, 'replace-domain')]/input")
    public Button updateDomainButton;

    @Name("Кнопки 'Отмена' на всех вкладках")
    @FindBy(xpath = ".//span[contains(@class, 'b-bfm__close')]")
    private List<Button> closeButtons;

    public Button getCloseButton() {
        return WebElementsActions.getVisibleElement(closeButtons);
    }

    public void fill(GroupChangesInfo groupChangesInfo) {
        tabs.clickTabByText(groupChangesInfo.getTab().toString());
        switch (groupChangesInfo.getTab()) {
            case SITE_LINK:
                fillHrefWithScheme(newSiteLink, newSitelinkschemeSelect, groupChangesInfo.getSiteLink(), false);
                takeScreenshot();
                replaceHrefButton.click();
                break;
            case LINK_PART:
                fillTextInput(linkPartFindBy, groupChangesInfo.getLinkPartFindBy());
                fillTextInput(linkPartReplaceWith, groupChangesInfo.getLinkPartReplaceWith());
                setCheckboxState(fixQuickLinks, groupChangesInfo.getFixQuickLinks());
                takeScreenshot();
                updateHrefButton.click();
                break;
            case TEXT_PART:
                fillTextInput(bodyPartFindBy, groupChangesInfo.getBodyPartFindBy());
                fillTextInput(bodyPartReplaceWith, groupChangesInfo.getBodyPartReplaceWith());
                takeScreenshot();
                updateTextButton.click();
                break;
            case QUICK_LINKS:
                linksPopupBlock.fillParameters(groupChangesInfo.getSiteLinks());
                clickOnClearAllLink(groupChangesInfo.getClearAllSiteLinks());
                takeScreenshot();
                addSiteLinksButton.click();
                if (groupChangesInfo.getClearAllSiteLinks() != null && groupChangesInfo.getClearAllSiteLinks()) {
                    onAlert().accept(equalTo(EditBannerResource.SITE_LINKS_WILL_BE_DELETED_ALERT_TEXT.toString()));
                }
                break;
            case DOMAIN:
                newDomain.clear();
                newDomain.sendKeys(groupChangesInfo.getDomain());
                takeScreenshot();
                updateDomainButton.click();
                break;
            case MINUS_KEYWORDS:
                minusKeywords.clear();
                minusKeywords.sendKeys(groupChangesInfo.getMinusKeywords());
                takeScreenshot();
                addMinusWordsButton.click();
                break;
        }
    }

    public void openGroupChangesTab(GroupChangesBlockTabs groupChangesBlockTabs) {
        tabs.clickTabByText(groupChangesBlockTabs.toString());
    }

    public void checkSiteLinks(SiteLinkInfoWeb[] siteLinks) {
        linksPopupBlock.checkParameters(siteLinks);
    }

    public void clickOnClearAllLink(Boolean isClear) {
        if (isClear != null && isClear) {
            linksPopupBlock.clickOnClearAllLink();
        }
    }

}
