package ru.yandex.autotests.direct.web.pages.mediaplans.blocks;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.priceconstructor.MediaplanTrafficVolume;
import ru.yandex.autotests.direct.web.pages.banners.blocks.phrases.BannerPhraseRowBlock;
import ru.yandex.autotests.direct.web.pages.mediaplans.elements.PhraseCheckBox;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Radio;

import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.exists;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */

public class MediaplanPhraseRowBlock extends BannerPhraseRowBlock {

    @Name("Цена 1-го спецразмещения")
    @FindBy(css = "div.b-phrases-list-phrase__pmax_price")
    protected WebElement priceFirstSpecialPlace;

    @Name("RadioButton для выбора цены клика")
    @FindBy(css = "input.b-phrases-list-phrase__radio")
    protected Radio priceRadioButton;

    @Name("Галочка для выбранной цены клика")
    @FindBy(xpath = ".//img[@src='/i/i-tick.gif']")
    protected WebElement priceTick;

    @Name("Переключатель фразы")
    @FindBy(xpath = ".//div[contains(@class, 'phrase__active-switcher')]")
    private PhraseCheckBox phraseCheckbox;

    @Name("Прогноз CTR для 1-го спецразмещения")
    @FindBy(xpath = ".//div[@class='b-phrases-list-phrase__pmax b-phrases-list-phrase__p_ctr']")
    private WebElement premiumFirstPlaceCTRForecast;

    @Name("Прогноз CTR для цены 1-го места")
    @FindBy(xpath = ".//div[@class='b-phrases-list-phrase__max b-phrases-list-phrase__fp_ctr']")
    private WebElement firstPlaceCTRForecast;

    @Name("Прогноз показов")
    @FindBy(xpath = ".//td[contains(@class, 'b-phrases-list__stat b-table__cell b-table__cell_type_number ')]")
    private WebElement showsForecast;

    @Name("Прогноз кликов для 1-го спецразмещения")
    @FindBy(xpath = ".//div[@class='b-phrases-list-phrase__pmax b-phrases-list-phrase__pmax_clicks']")
    private WebElement premiumFirstPlaceClicksForecast;

    @Name("Прогноз кликов для цены 1-го места")
    @FindBy(xpath = ".//div[@class='b-phrases-list-phrase__max b-phrases-list-phrase__max_clicks']")
    private WebElement firstPlaceClicksForecast;

    @Name("Прогноз бюджета для 1-го спецразмещения")
    @FindBy(xpath = ".//div[contains(@class, 'b-phrases-list-phrase__pmax_budget')]")
    private WebElement premiumFirstPlaceBudgetForecast;

    @Name("Прогноз бюджета для цены 1-го места")
    @FindBy(xpath = ".//div[contains(@class, 'b-phrases-list-phrase__max_budget')]")
    private WebElement firstPlaceBudgetForecast;

    public MediaplanTrafficVolume getPriceType() {
        if (exists().matches(priceTick)) {
            String className = priceTick.findElement(By.xpath(".//parent::div")).getAttribute("class");
             if (className.endsWith("pmax")) {
                return MediaplanTrafficVolume.HUNDRED;
            } else if (className.endsWith("min")) {
                return MediaplanTrafficVolume.FIVE;
            } else {
                throw new DirectWebError("Can't get price from tick");
            }
        } else {
            String val = priceRadioButton.getSelectedButton().getAttribute("value");
            return MediaplanTrafficVolume.getPriceTypeById(Integer.parseInt(val));
        }
    }

    public String getPriceGuarantyFirst() {
        return priceGuarantyFirst.getText();
    }

    public String getPriceFirstSpecialPlace() {
        return priceFirstSpecialPlace.getText();
    }

    public void deselectPhraseSwitcher() {
        phraseCheckbox.deselect();
    }

    public void setPhraseCheckBox(boolean state) {
        phraseCheckBox.set(state);
    }

    public String getShowsForecast() {
        return showsForecast.getText().replace(" ", "");
    }

    public String getCTRForecast(MediaplanTrafficVolume trafficVolume) {
        String CTRForecast;
        switch (trafficVolume) {
            case FIVE:
                CTRForecast = firstPlaceCTRForecast.getText();
                break;
            case HUNDRED:
                CTRForecast = premiumFirstPlaceCTRForecast.getText();
                break;
            default:
                return null;
        }
        return CTRForecast.replace(" ", "");
    }

    public String getClicksForecast(MediaplanTrafficVolume trafficVolume) {
        String clicks;
        switch (trafficVolume) {
            case FIVE:
                clicks = firstPlaceClicksForecast.getText();
                break;
            case HUNDRED:
                clicks = premiumFirstPlaceClicksForecast.getText();
                break;
            default:
                return null;
        }
        return clicks.replace(" ", "");
    }

    public String getBudgetForecast(MediaplanTrafficVolume trafficVolume) {
        String budgetForecast;
        switch (trafficVolume) {
            case FIVE:
                budgetForecast = firstPlaceBudgetForecast.getText();
                break;
            case HUNDRED:
                budgetForecast = premiumFirstPlaceBudgetForecast.getText();
                break;
            default:
                return null;
        }
        return budgetForecast.replace(" ", "");
    }
}
